
# 🏗️ System Architecture & Connection Guide

**Project:** SQB Hardware Store (Microkernel Edition)
**Status:** 🔒 HARDENED MODE
**Last Updated:** 2026-01-01

---

## 1. 🌐 Server Connection Details

The application is deployed on a local on-premise server.

### 🔑 SSH Access
*   **IP Address:** `192.168.1.166`
*   **Username:** `cube`
*   **Password:** `cube`
*   **Command:**
    ```bash
    ssh cube@192.168.1.166
    ```

### 🐳 Docker Architecture (Remote)
The system runs on **Docker** with three primary containers:

| Container Name | Image | Port (Host) | Internal Port | Description |
| :--- | :--- | :--- | :--- | :--- |
| **`postgres`** | `postgres:15` | `5432` | `5432` | The primary database. |
| **`smd-backend`** | `node:20-alpine` | `3001` | `3001` | The API Server (Express + Prisma). |
| **`smd-frontend`** | `nginx:alpine` | `80` | `80` | Nginx Proxy serving React Apps + API. |

### 🌍 Application URLs (Local Network)
*   **Customer Storefront:** `http://192.168.1.166/`
*   **Admin Dashboard:** `http://192.168.1.166/admin`
*   **API Endpoint:** `http://192.168.1.166/api`

---

## 2. 🧩 Application Architecture (Microkernel)

The system uses a **Microkernel Architecture** designed for modularity and stability.

### 🧠 Core Philosophy
*   **The Core**: Contains the essential business logic (Orders, Auth, Products) and the "Plumbing" (`HookSystem`, `PluginManager`).
*   **The Plugins**: Contain optional or region-specific logic (e.g., `tax-tunisia`, `inventory-management`).
*   **Hardened Mode**: The core assumes plugins are "untrusted" and wraps them in safety guards (Crash Containment, Audit Logs).

### 🔙 Backend Architecture (Node.js + Express)
1.  **Event Bus (`HookSystem.ts`)**:
    *   Implements a "Waterfall" pipeline.
    *   Plugins register handlers for events like `order.validate` or `tax.calculate`.
    *   **Safety**: Catches crashes and guards against duplicate execution.
2.  **Plugin Manager (`PluginManager.ts`)**:
    *   Loads plugins from `src/plugins` or uploaded Zips.
    *   **Security**: Audits every API route registered by a plugin.
3.  **Data Layer (Prisma ORM)**:
    *   Connects to PostgreSQL.
    *   Manages schema for `User`, `Order`, `Product`, etc.

### 🎨 Frontend Architecture (React + Vite)
1.  **Component Registry (`ComponentRegistry.tsx`)**:
    *   Allows plugins to "inject" UI components into specific "Slots".
    *   Example: A `cart-plugin` injects a "Checkout Button" into the `cart_actions` slot.
2.  **Extension Slots (`<ExtensionSlot />`)**:
    *   Placeholders in the UI (e.g., on the Product Page) that render whatever components plugins have registered.

---

## 3. 🛡️ Hardened Mode Guarantees
The system currently implements **Platform Stability Rules**:

1.  **Crash Containment**: A plugin crash does NOT bring down the server (it fails the request safely with a 500 error).
2.  **Determinism**: The server waits for all plugins to initialize before accepting traffic.
3.  **Financial Integrity**: Any attempt to modify a `DELIVERED` order generates a high-severity Audit Log.
4.  **Security Visibility**: All plugin routes are logged at startup.

---

## 4. 📂 Directory Structure

```text
/
├── backend/
│   ├── src/
│   │   ├── core/           # HookSystem, PluginManager
│   │   ├── controllers/    # Core Business Logic
│   │   ├── plugins/        # Backend Plugins (e.g., tax-tunisia)
│   │   └── server.ts       # Entry Point (Hardened)
│   └── prisma/             # Database Schema
├── src/ (Frontend)
│   ├── core/               # ComponentRegistry
│   ├── plugins/            # Frontend Plugins
│   └── App.tsx             # Main React App
└── docker-compose.yml      # Deployment Orchestration
```
