
const { PrismaClient } = require('@prisma/client');
const prisma = new PrismaClient();

async function main() {
    try {
        console.log('--- CREATING DEFAULT CATALOG ---');

        const catalog = await prisma.catalog.upsert({
            where: { id: 'CAT_DEFAULT' },
            create: {
                id: 'CAT_DEFAULT',
                name: 'General Catalog',
                slug: 'general',
                isActive: true,
                isDefault: true,
                defaultTvaRate: 19
            },
            update: {
                isDefault: true,
                isActive: true
            }
        });

        console.log('✅ Default Catalog ensured:', catalog);

        // Update all existing products to belong to this catalog if they don't have one
        // Note: If schema requires catalogId, products created without one would have failed. 
        // But if we have products, update them.
        const updateResult = await prisma.product.updateMany({
            where: { catalogId: null },
            data: { catalogId: catalog.id }
        });

        console.log(`Updated ${updateResult.count} products to belong to default catalog.`);

    } catch (e) {
        console.error('Error creating catalog:', e);
    } finally {
        await prisma.$disconnect();
    }
}

main();
