import { Response, NextFunction } from 'express';
import { AuthRequest } from '../middleware/auth.js';
/**
 * Create a new customer (Admin only)
 */
export declare const createCustomer: (req: AuthRequest, res: Response, next: NextFunction) => Promise<void>;
/**
 * Get all customers (Admin only)
 */
export declare const getAllCustomers: (req: AuthRequest, res: Response, next: NextFunction) => Promise<void>;
/**
 * Get customer by ID (Admin only)
 */
export declare const getCustomerById: (req: AuthRequest, res: Response, next: NextFunction) => Promise<void>;
/**
 * Update customer (Admin only)
 */
export declare const updateCustomer: (req: AuthRequest, res: Response, next: NextFunction) => Promise<void>;
/**
 * Delete customer (Admin only)
 */
export declare const deleteCustomer: (req: AuthRequest, res: Response, next: NextFunction) => Promise<Response<any, Record<string, any>>>;
/**
 * Reset customer password (Admin only)
 */
export declare const resetCustomerPassword: (req: AuthRequest, res: Response, next: NextFunction) => Promise<void>;
//# sourceMappingURL=customer.controller.d.ts.map