import { Response } from 'express';
import { AuthRequest } from '../middleware/auth.js';
export declare const createQuotation: (req: AuthRequest, res: Response) => Promise<Response<any, Record<string, any>>>;
export declare const getAllQuotations: (req: AuthRequest, res: Response) => Promise<void>;
export declare const getQuotationById: (req: AuthRequest, res: Response) => Promise<Response<any, Record<string, any>>>;
export declare const submitQuotation: (req: AuthRequest, res: Response) => Promise<Response<any, Record<string, any>>>;
/**
 * Update quotation (Admin only)
 * Allows admin to modify quantities or remove items before approving
 */
export declare const updateQuotation: (req: AuthRequest, res: Response) => Promise<Response<any, Record<string, any>>>;
export declare const approveQuotation: (req: AuthRequest, res: Response) => Promise<Response<any, Record<string, any>>>;
export declare const declineQuotation: (req: AuthRequest, res: Response) => Promise<Response<any, Record<string, any>>>;
export declare const deleteQuotation: (req: AuthRequest, res: Response) => Promise<Response<any, Record<string, any>>>;
//# sourceMappingURL=quotation.controller.d.ts.map