/**
 * Core Hook System (Event Bus)
 *
 * Implements a "Waterfull" or "Pipeline" pattern where plugins can intercept,
 * modify, or augment data flow.
 */
export type HookContext = any;
export type HookNextFunction = () => Promise<void>;
export type HookHandler = (context: HookContext, next: HookNextFunction) => Promise<void>;
export declare class HookSystem {
    private hooks;
    /**
     * Register a handler for a specific hook
     * @param hookName The name of the containment point (e.g. 'order.validate')
     * @param handler The function to execute
     */
    on(hookName: string, handler: HookHandler): void;
    /**
     * Trigger a hook. Handlers are executed sequentially.
     * @param hookName
     * @param context The mutable context object passed through handlers
     * @returns The modified context
     */
    trigger<T>(hookName: string, context: T): Promise<T>;
}
export declare const hooks: HookSystem;
//# sourceMappingURL=HookSystem.d.ts.map