import { Request, Response, NextFunction } from 'express';
export interface AuthRequest extends Request {
    user?: {
        id: string;
        email: string;
        role: string;
    };
}
export declare const ROLES: {
    SUPER_ADMIN: string;
    ADMIN: string;
    SALES_ADMIN: string;
    CATALOG_ADMIN: string;
    ACCOUNTING_ADMIN: string;
    SUPPORT_ADMIN: string;
    MANAGER: string;
    CUSTOMER: string;
};
export declare const PERMISSIONS: {
    ALL_ADMINS: string[];
    FULL_ACCESS: string[];
    CATALOG_MANAGE: string[];
    SALES_MANAGE: string[];
    SALES_VIEW: string[];
    ACCOUNTING_MANAGE: string[];
    ACCOUNTING_VIEW: string[];
    CUSTOMER_MANAGE: string[];
    CUSTOMER_VIEW: string[];
    SETTINGS_MANAGE: string[];
};
export declare const authenticate: (req: AuthRequest, res: Response, next: NextFunction) => Promise<void>;
export declare const authorize: (...roles: string[]) => (req: AuthRequest, res: Response, next: NextFunction) => void;
//# sourceMappingURL=auth.d.ts.map