export declare const TVA_RATES: {
    readonly STANDARD: 19;
    readonly REDUCED: 7;
    readonly EXEMPT: 0;
};
export declare function getEffectiveTvaRate(productId: string, catalogId: string): Promise<{
    rate: number;
    exempt: boolean;
    reason?: string;
}>;
export interface LineItemInput {
    quantity: number;
    unitPrice: number;
    discount?: number;
    tvaRate: number;
    tvaExempt: boolean;
    fodecSubject?: boolean;
}
export interface LineItemResult {
    totalBrutHT: number;
    discount: number;
    totalNetHT: number;
    fodecAmount: number;
    tvaAmount: number;
    totalTTC: number;
    tvaBase: number;
    tvaRate: number;
    tvaExempt: boolean;
}
export interface TaxConfig {
    standardRate: number;
    reducedRate: number;
    fodecRate: number;
    enableStamp: boolean;
    stampValue: number;
}
export declare function calculateLineItem(item: LineItemInput, config?: TaxConfig): LineItemResult;
export interface DocumentTvaSummary {
    totalBrutHT: number;
    totalDiscount: number;
    totalNetHT: number;
    totalFodec: number;
    tva19Amount: number;
    tva7Amount: number;
    tva0Amount: number;
    totalTVA: number;
    netAPayer: number;
    netAPayerWords: string;
    stampAmount: number;
}
export declare function calculateDocumentTva(lineItems: LineItemResult[], config?: TaxConfig): DocumentTvaSummary;
export declare function numberToFrenchWords(amount: number): string;
export declare function isCustomerTvaExempt(userId: string): Promise<boolean>;
//# sourceMappingURL=logic.d.ts.map