"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const admin_controller_js_1 = require("../controllers/admin.controller.js");
const auth_js_1 = require("../middleware/auth.js");
const router = (0, express_1.Router)();
// All routes require authentication and SUPER_ADMIN role (or ADMIN for legacy compatibility)
// We treat 'ADMIN' as Super Admin for now to avoid breaking existing users
router.use(auth_js_1.authenticate);
router.use((0, auth_js_1.authorize)('SUPER_ADMIN', 'ADMIN'));
router.get('/', admin_controller_js_1.listAdmins);
router.post('/', admin_controller_js_1.createAdmin);
router.put('/:id/role', admin_controller_js_1.updateAdminRole);
router.delete('/:id', admin_controller_js_1.deleteAdmin);
exports.default = router;
//# sourceMappingURL=admin.routes.js.map