"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const banner_controller_1 = require("../controllers/banner.controller");
const auth_1 = require("../middleware/auth");
const router = (0, express_1.Router)();
// Public routes
router.get('/', banner_controller_1.getAllBannerSlides);
router.get('/:id', banner_controller_1.getBannerSlide);
// Admin routes
router.get('/admin/all', auth_1.authenticate, (0, auth_1.authorize)(...auth_1.PERMISSIONS.CATALOG_MANAGE), banner_controller_1.getAllBannerSlidesAdmin);
router.post('/', auth_1.authenticate, (0, auth_1.authorize)(...auth_1.PERMISSIONS.CATALOG_MANAGE), banner_controller_1.createBannerSlide);
router.put('/:id', auth_1.authenticate, (0, auth_1.authorize)(...auth_1.PERMISSIONS.CATALOG_MANAGE), banner_controller_1.updateBannerSlide);
router.delete('/:id', auth_1.authenticate, (0, auth_1.authorize)(...auth_1.PERMISSIONS.CATALOG_MANAGE), banner_controller_1.deleteBannerSlide);
router.post('/reorder', auth_1.authenticate, (0, auth_1.authorize)(...auth_1.PERMISSIONS.CATALOG_MANAGE), banner_controller_1.reorderBannerSlides);
exports.default = router;
//# sourceMappingURL=banner.routes.js.map