"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const invoice_controller_js_1 = require("../controllers/invoice.controller.js");
const auth_js_1 = require("../middleware/auth.js");
const router = express_1.default.Router();
// Get customer's own invoices
router.get('/', auth_js_1.authenticate, invoice_controller_js_1.getMyInvoices);
// Get specific invoice
router.get('/:id', auth_js_1.authenticate, invoice_controller_js_1.getInvoiceById);
exports.default = router;
//# sourceMappingURL=invoice.routes.js.map