"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const order_controller_1 = require("../controllers/order.controller");
const auth_js_1 = require("../middleware/auth.js");
const router = express_1.default.Router();
/**
 * Customer routes (authenticated customers)
 */
// Get customer's own orders (must be before GET /)
router.get('/my-orders', auth_js_1.authenticate, order_controller_1.getMyOrders);
// Create new order (authenticated customers)
router.post('/', auth_js_1.authenticate, order_controller_1.createOrder);
// Cancel order (customer can cancel their own pending orders)
router.put('/:id/cancel', auth_js_1.authenticate, order_controller_1.cancelOrder);
/**
 * Admin routes (admin/manager only)
 */
// Get all orders (admin only) - must be before GET /:id
router.get('/', auth_js_1.authenticate, (0, auth_js_1.authorize)(...auth_js_1.PERMISSIONS.SALES_VIEW), order_controller_1.getAllOrders);
// Update order status (admin only)
router.put('/:id/status', auth_js_1.authenticate, (0, auth_js_1.authorize)(...auth_js_1.PERMISSIONS.SALES_MANAGE), order_controller_1.updateOrderStatus);
// Update payment status (admin only)
router.put('/:id/payment-status', auth_js_1.authenticate, (0, auth_js_1.authorize)(...auth_js_1.PERMISSIONS.SALES_MANAGE), order_controller_1.updatePaymentStatus);
// Get specific order (customer can only see their own, admin can see all)
router.get('/:id', auth_js_1.authenticate, order_controller_1.getOrderById);
exports.default = router;
//# sourceMappingURL=order.routes.js.map