"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const multer_1 = __importDefault(require("multer"));
const path_1 = __importDefault(require("path"));
const auth_js_1 = require("../middleware/auth.js");
const plugin_controller_js_1 = require("../controllers/plugin.controller.js");
const router = express_1.default.Router();
// Multer Setup
const storage = multer_1.default.diskStorage({
    destination: (req, file, cb) => {
        cb(null, 'uploads/'); // Temporary upload dir
    },
    filename: (req, file, cb) => {
        cb(null, `plugin-${Date.now()}${path_1.default.extname(file.originalname)}`);
    }
});
const upload = (0, multer_1.default)({ storage });
// Protected Routes (Admin Only)
router.use(auth_js_1.authenticate);
router.use((0, auth_js_1.authorize)('ADMIN', 'SUPER_ADMIN'));
router.get('/', plugin_controller_js_1.getPlugins);
router.get('/navigation', plugin_controller_js_1.getNavigation);
router.post('/:name/toggle', plugin_controller_js_1.togglePlugin);
router.get('/:name/config', plugin_controller_js_1.getPluginConfig);
router.put('/:name/config', plugin_controller_js_1.updatePluginConfig);
router.post('/upload', upload.single('plugin'), plugin_controller_js_1.uploadPlugin);
exports.default = router;
//# sourceMappingURL=plugin.routes.js.map