"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const quotation_controller_1 = require("../controllers/quotation.controller");
const auth_1 = require("../middleware/auth");
const router = express_1.default.Router();
// All routes require authentication
router.use(auth_1.authenticate);
// Customer routes
router.post('/', quotation_controller_1.createQuotation); // Create draft quotation
router.get('/', quotation_controller_1.getAllQuotations); // List quotations (filtered by role)
router.get('/:id', quotation_controller_1.getQuotationById); // Get quotation details
router.post('/:id/submit', quotation_controller_1.submitQuotation); // Submit for approval
router.delete('/:id', quotation_controller_1.deleteQuotation); // Delete draft
// Admin/Manager routes
router.put('/:id', (0, auth_1.authorize)(...auth_1.PERMISSIONS.SALES_MANAGE), quotation_controller_1.updateQuotation); // Update quotation (edit items/quantities)
router.put('/:id/approve', (0, auth_1.authorize)(...auth_1.PERMISSIONS.SALES_MANAGE), quotation_controller_1.approveQuotation); // Approve & convert to order
router.put('/:id/decline', (0, auth_1.authorize)(...auth_1.PERMISSIONS.SALES_MANAGE), quotation_controller_1.declineQuotation); // Decline quotation
exports.default = router;
//# sourceMappingURL=quotation.routes.js.map