"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const cors_1 = __importDefault(require("cors"));
const helmet_1 = __importDefault(require("helmet"));
const compression_1 = __importDefault(require("compression"));
const morgan_1 = __importDefault(require("morgan"));
const dotenv_1 = __importDefault(require("dotenv"));
const express_rate_limit_1 = __importDefault(require("express-rate-limit"));
// Load environment variables
dotenv_1.default.config();
// Import routes
const auth_routes_js_1 = __importDefault(require("./routes/auth.routes.js"));
const category_routes_js_1 = __importDefault(require("./routes/category.routes.js"));
const catalog_routes_js_1 = __importDefault(require("./routes/catalog.routes.js"));
const product_routes_js_1 = __importDefault(require("./routes/product.routes.js"));
const upload_routes_js_1 = __importDefault(require("./routes/upload.routes.js"));
const customer_routes_js_1 = __importDefault(require("./routes/customer.routes.js"));
const order_routes_js_1 = __importDefault(require("./routes/order.routes.js"));
const banner_routes_js_1 = __importDefault(require("./routes/banner.routes.js"));
const quotation_routes_js_1 = __importDefault(require("./routes/quotation.routes.js"));
const dashboard_routes_js_1 = __importDefault(require("./routes/dashboard.routes.js"));
const invoice_routes_js_1 = __importDefault(require("./routes/invoice.routes.js"));
const accounting_routes_js_1 = __importDefault(require("./routes/accounting.routes.js"));
const settings_routes_js_1 = __importDefault(require("./routes/settings.routes.js"));
const admin_routes_js_1 = __importDefault(require("./routes/admin.routes.js"));
const plugin_routes_js_1 = __importDefault(require("./routes/plugin.routes.js"));
// Import middleware
const errorHandler_js_1 = require("./middleware/errorHandler.js");
const notFound_js_1 = require("./middleware/notFound.js");
const app = (0, express_1.default)();
const PORT = process.env.PORT || 3001;
// Plugin System Initialization
const PluginManager_js_1 = require("./core/PluginManager.js");
const taxPlugin = __importStar(require("./plugins/tax-tunisia/index.js"));
const pluginManager = new PluginManager_js_1.PluginManager(app);
// Register Core Plugins
pluginManager.register(taxPlugin);
// Initialize plugins
// Note: We use an IIFE or similar if top-level await isn't supported, 
// but we'll assume the server startup can handle async, or we call init inside listen?
// Better to init before creating routes so plugins can register routes.
// We will call init() immediately but since it is async, we need to handle valid startup.
// For now, let's just trigger it.
// Plugin init is now handled in startServer()
// ============================================
// MIDDLEWARE
// ============================================
// Security
app.use((0, helmet_1.default)());
// CORS
const corsOptions = {
    origin: [
        'http://localhost:5173',
        'http://localhost:5174',
        'http://localhost:5175',
        ...(process.env.CORS_ORIGIN?.split(',') || [])
    ],
    credentials: true,
};
app.use((0, cors_1.default)(corsOptions));
// Body parsing
app.use(express_1.default.json({ limit: '10mb' }));
app.use(express_1.default.urlencoded({ extended: true, limit: '10mb' }));
// Compression
app.use((0, compression_1.default)());
// Logging
if (process.env.NODE_ENV === 'development') {
    app.use((0, morgan_1.default)('dev'));
}
else {
    app.use((0, morgan_1.default)('combined'));
}
// Rate limiting
const limiter = (0, express_rate_limit_1.default)({
    windowMs: parseInt(process.env.RATE_LIMIT_WINDOW_MS || '900000'), // 15 minutes
    max: parseInt(process.env.RATE_LIMIT_MAX_REQUESTS || '10000'), // Increased from 1000 to 10000 for development
    message: 'Too many requests from this IP, please try again later.',
    standardHeaders: true, // Return rate limit info in the `RateLimit-*` headers
    legacyHeaders: false, // Disable the `X-RateLimit-*` headers
    // Skip rate limiting in development if needed
    skip: (req) => {
        // Skip rate limiting for development environment
        return process.env.NODE_ENV === 'development';
    },
});
app.use('/api/', limiter);
// Static files (uploads)
app.use('/uploads', express_1.default.static('uploads'));
// ============================================
// ROUTES
// ============================================
// Health check
app.get('/health', (req, res) => {
    res.json({
        status: 'OK',
        timestamp: new Date().toISOString(),
        uptime: process.uptime(),
        environment: process.env.NODE_ENV,
    });
});
// API routes
// Attach to app for controllers
app.set('pluginManager', pluginManager);
// API routes
app.use('/api/auth', auth_routes_js_1.default);
app.use('/api/categories', category_routes_js_1.default);
app.use('/api/catalogs', catalog_routes_js_1.default);
app.use('/api/products', product_routes_js_1.default);
app.use('/api/upload', upload_routes_js_1.default);
app.use('/api/customers', customer_routes_js_1.default);
app.use('/api/orders', order_routes_js_1.default);
app.use('/api/quotations', quotation_routes_js_1.default);
app.use('/api/invoices', invoice_routes_js_1.default);
app.use('/api/banners', banner_routes_js_1.default);
app.use('/api/dashboard', dashboard_routes_js_1.default);
app.use('/api/admin/accounting', accounting_routes_js_1.default);
app.use('/api/admin/users', admin_routes_js_1.default);
app.use('/api/admin/plugins', plugin_routes_js_1.default); // Plugins Route
app.use('/api/settings', settings_routes_js_1.default);
// ============================================
// ERROR HANDLING
// ============================================
app.use(notFound_js_1.notFound);
app.use(errorHandler_js_1.errorHandler);
// ============================================
// START SERVER
// ============================================
// [HARDENING] Deterministic Startup
const startServer = async () => {
    try {
        // Initialize plugins BEFORE listening
        // This ensures routes are verified and hooks are ready
        console.log('[Server] Initializing Plugin System...');
        await pluginManager.init();
        app.listen(PORT, () => {
            console.log(`
╔═══════════════════════════════════════════╗
║   SQB Hardware Store API Server          ║
║   Environment: ${process.env.NODE_ENV?.padEnd(28) || 'development'.padEnd(28)}║
║   Port: ${PORT.toString().padEnd(34)}║
║   Status: Running ✓                       ║
╚═══════════════════════════════════════════╝
      `);
        });
    }
    catch (err) {
        console.error('🚨 Server Startup Failed:', err);
        process.exit(1);
    }
};
startServer();
// Graceful shutdown
process.on('SIGTERM', () => {
    console.log('SIGTERM signal received: closing HTTP server');
    process.exit(0);
});
process.on('SIGINT', () => {
    console.log('SIGINT signal received: closing HTTP server');
    process.exit(0);
});
exports.default = app;
//# sourceMappingURL=server.js.map