"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.suspended = exports.running = exports.isSuspended = exports.isRunning = exports.isFiberStatus = exports.isDone = exports.done = exports.FiberStatusTypeId = void 0;
var internal = _interopRequireWildcard(require("./internal/fiberStatus.js"));
function _interopRequireWildcard(e, t) { if ("function" == typeof WeakMap) var r = new WeakMap(), n = new WeakMap(); return (_interopRequireWildcard = function (e, t) { if (!t && e && e.__esModule) return e; var o, i, f = { __proto__: null, default: e }; if (null === e || "object" != typeof e && "function" != typeof e) return f; if (o = t ? n : r) { if (o.has(e)) return o.get(e); o.set(e, f); } for (const t in e) "default" !== t && {}.hasOwnProperty.call(e, t) && ((i = (o = Object.defineProperty) && Object.getOwnPropertyDescriptor(e, t)) && (i.get || i.set) ? o(f, t, i) : f[t] = e[t]); return f; })(e, t); }
/**
 * @since 2.0.0
 * @category symbols
 */
const FiberStatusTypeId = exports.FiberStatusTypeId = internal.FiberStatusTypeId;
/**
 * @since 2.0.0
 * @category constructors
 */
const done = exports.done = internal.done;
/**
 * @since 2.0.0
 * @category constructors
 */
const running = exports.running = internal.running;
/**
 * @since 2.0.0
 * @category constructors
 */
const suspended = exports.suspended = internal.suspended;
/**
 * Returns `true` if the specified value is a `FiberStatus`, `false` otherwise.
 *
 * @since 2.0.0
 * @category refinements
 */
const isFiberStatus = exports.isFiberStatus = internal.isFiberStatus;
/**
 * Returns `true` if the specified `FiberStatus` is `Done`, `false` otherwise.
 *
 * @since 2.0.0
 * @category refinements
 */
const isDone = exports.isDone = internal.isDone;
/**
 * Returns `true` if the specified `FiberStatus` is `Running`, `false`
 * otherwise.
 *
 * @since 2.0.0
 * @category refinements
 */
const isRunning = exports.isRunning = internal.isRunning;
/**
 * Returns `true` if the specified `FiberStatus` is `Suspended`, `false`
 * otherwise.
 *
 * @since 2.0.0
 * @category refinements
 */
const isSuspended = exports.isSuspended = internal.isSuspended;
//# sourceMappingURL=FiberStatus.js.map