
import { PrismaClient } from '@prisma/client';
import jwt from 'jsonwebtoken';
import fs from 'fs';

const prisma = new PrismaClient();

async function verifyAccountingApi() {
    try {
        const email = 'admin@smd-tunisie.com';

        // 1. Get User
        const user = await prisma.user.findUnique({ where: { email } });
        if (!user) {
            console.log('❌ User not found');
            return;
        }

        // 2. Generate Token
        const secret = process.env.JWT_SECRET || 'your-super-secret-jwt-key-change-in-production';
        const token = jwt.sign({ id: user.id, email: user.email, role: user.role }, secret, { expiresIn: '1h' });
        console.log('✅ Token generated');

        // 3. Call API
        const apiUrl = 'http://localhost:3001/api/admin/accounting/stats';
        console.log(`Testing API: ${apiUrl}`);

        const response = await fetch(apiUrl, {
            headers: {
                'Authorization': `Bearer ${token}`,
                'Content-Type': 'application/json'
            }
        });

        console.log(`Response Status: ${response.status}`);

        if (response.ok) {
            const data = await response.json();
            const output = '✅ API Success:\n' + JSON.stringify(data, null, 2);
            fs.writeFileSync('verification_result.txt', output);
        } else {
            const text = await response.text();
            const output = '❌ API Failed:\n' + text;
            fs.writeFileSync('verification_result.txt', output);
        }

    } catch (error) {
        fs.writeFileSync('verification_result.txt', 'Error: ' + error);
    } finally {
        await prisma.$disconnect();
    }
}

verifyAccountingApi().catch(e => {
    fs.writeFileSync('verification_result.txt', 'Unhandled: ' + e);
});
