import prisma from './src/config/database.js';

async function inspectUsers() {
    try {
        const users = await prisma.user.findMany();
        console.log('Found users:', users.length);
        users.forEach(u => {
            console.log(`- ${u.email} (Role: ${u.role}, Active: ${u.isActive})`);
            console.log(`  Hash: ${u.passwordHash.substring(0, 10)}...`);
        });
    } catch (error) {
        console.error('Error:', error);
    } finally {
        await prisma.$disconnect();
    }
}

inspectUsers();
