
import { buildAuthHeaders } from '../utils/apiClient';

const API_URL = import.meta.env.VITE_API_URL || 'http://localhost:3001/api';

export interface SettingsData {
    notifications: {
        email: boolean;
        newOrders: boolean;
        newQuotations: boolean;
        lowStock: boolean;
        systemUpdates: boolean;
    };
    business: {
        companyName: string;
        email: string;
        phone: string;
        address: string;
        taxId: string;
        currency: string;
    };
    system: {
        maintenanceMode: boolean;
        autoBackup: boolean;
        sessionTimeout: number;
    };
}

export const settingsService = {
    /**
     * Get all settings
     */
    async getSettings(): Promise<SettingsData> {
        const response = await fetch(`${API_URL}/settings`, {
            headers: buildAuthHeaders(),
        });

        if (!response.ok) {
            const error = await response.json();
            throw new Error(error.error?.message || 'Failed to fetch settings');
        }

        const data = await response.json();
        return data.data;
    },

    /**
     * Update settings
     */
    async updateSettings(settings: SettingsData): Promise<void> {
        const response = await fetch(`${API_URL}/settings`, {
            method: 'POST',
            headers: buildAuthHeaders(),
            body: JSON.stringify(settings),
        });

        if (!response.ok) {
            const error = await response.json();
            throw new Error(error.error?.message || 'Failed to update settings');
        }

        return;
    }
};
