import { SELECTED_CATALOG_STORAGE_KEY } from '../constants/catalog';

export const getAuthToken = (): string | null => {
  return localStorage.getItem('admin_token');
};

export const getSelectedCatalogId = (): string | null => {
  return localStorage.getItem(SELECTED_CATALOG_STORAGE_KEY);
};

interface BuildHeadersOptions {
  includeJson?: boolean;
  catalogId?: string | null;
}


export const buildAuthHeaders = (options: BuildHeadersOptions = {}): Record<string, string> => {
  const { includeJson = true, catalogId: catalogIdOverride } = options;
  const headers: Record<string, string> = {};

  if (includeJson) {
    headers['Content-Type'] = 'application/json';
  }

  const token = getAuthToken();
  const catalogId = catalogIdOverride ?? getSelectedCatalogId();


  if (token) {
    headers['Authorization'] = `Bearer ${token}`;
  }

  if (catalogId) {
    headers['x-catalog-id'] = catalogId;
  }

  return headers;
};
