#!/bin/bash

################################################################################
# Deploy Dockerized App to VPS
################################################################################

set -e

# Colors
GREEN='\033[0;32m'
BLUE='\033[0;34m'
RED='\033[0;31m'
NC='\033[0m'

VPS_HOST="root@51.75.143.218"
VPS_PATH="/var/www/sqb-tunisie/docker"

log() {
    echo -e "${GREEN}[$(date +'%H:%M:%S')]${NC} $1"
}

info() {
    echo -e "${BLUE}[INFO]${NC} $1"
}

error() {
    echo -e "${RED}[ERROR]${NC} $1"
}

# 1. Prepare VPS
log "Preparing VPS..."
ssh $VPS_HOST "mkdir -p $VPS_PATH"

# 2. Sync Files
log "Syncing configuration files..."
rsync -avz --delete \
    --exclude 'node_modules' \
    --exclude 'dist' \
    --exclude '.git' \
    --exclude '.env' \
    --exclude 'uploads' \
    ./ $VPS_HOST:$VPS_PATH/

# 3. Create .env on VPS if missing
log "Checking .env on VPS..."
ssh $VPS_HOST "
    if [ ! -f $VPS_PATH/.env ]; then
        echo 'Creating .env from example...'
        cp $VPS_PATH/.env.production.example $VPS_PATH/.env
        echo 'WARNING: Please update .env with real values!'
    fi
"

# 4. Deploy
log "Deploying with Docker Compose..."
ssh $VPS_HOST "cd $VPS_PATH && docker-compose up -d --build"

# 5. Run Migrations
log "Running database migrations..."
ssh $VPS_HOST "cd $VPS_PATH && docker-compose exec -T backend npx prisma migrate deploy"

log "✓ Deployment Complete!"
info "Check status: ssh $VPS_HOST 'cd $VPS_PATH && docker-compose ps'"
