import React from 'react';
import { ShoppingCart } from 'lucide-react';
import { Product } from '../../types/api';

interface AddToCartButtonProps {
    product: Product;
    selectedVariation: any;
    quantity: number;
    onAddToCart: (product: Product, selectedSize?: any, selectedPack?: any) => void;
    displayStock: number;
}

export const AddToCartButton: React.FC<AddToCartButtonProps> = ({
    product,
    selectedVariation,
    quantity,
    onAddToCart,
    displayStock
}) => {

    const handleAddToCart = () => {
        if (product && selectedVariation) {
            // Prepare size or pack data for cart
            const sizeData = selectedVariation.type === 'size' && selectedVariation.id ? {
                id: selectedVariation.id,
                size: selectedVariation.label || '',
                label: selectedVariation.label,
                price: selectedVariation.price,
                stock: selectedVariation.stock,
                unitType: selectedVariation.unitType || 'piece'
            } : undefined;

            const packData = selectedVariation.type === 'pack' && selectedVariation.id ? {
                id: selectedVariation.id,
                packType: selectedVariation.label || '',
                label: selectedVariation.label,
                price: selectedVariation.price,
                stock: selectedVariation.stock,
                packQuantity: product.packSizes?.find((p: any) => p.id === selectedVariation.id)?.packQuantity || 1
            } : undefined;

            // Create a modified product with selected variation price
            const productToAdd = {
                ...product,
                price: selectedVariation.price,
                basePrice: selectedVariation.price,
                stock: selectedVariation.stock,
                stockQuantity: selectedVariation.stock
            };

            // Add to cart with quantity
            for (let i = 0; i < quantity; i++) {
                onAddToCart(productToAdd, sizeData, packData);
            }
        }
    };

    return (
        <button
            onClick={handleAddToCart}
            disabled={displayStock === 0}
            className={`w-full py-4 rounded-lg font-semibold text-lg flex items-center justify-center gap-2 transition-colors ${displayStock === 0
                ? 'bg-gray-300 text-gray-500 cursor-not-allowed'
                : 'bg-blue-600 text-white hover:bg-blue-700'
                }`}
        >
            <ShoppingCart className="w-6 h-6" />
            {displayStock === 0 ? 'Out of Stock' : 'Add to Cart'}
        </button>
    );
};
