import { Response } from 'express';
import { AuthRequest } from '../middleware/auth.js';
/**
 * Create a new order
 * POST /api/orders
 */
export declare const createOrder: (req: AuthRequest, res: Response) => Promise<Response<any, Record<string, any>>>;
/**
 * Get all orders (Admin only)
 * GET /api/orders
 */
export declare const getAllOrders: (req: AuthRequest, res: Response) => Promise<Response<any, Record<string, any>>>;
/**
 * Get order by ID
 * GET /api/orders/:id
 */
export declare const getOrderById: (req: AuthRequest, res: Response) => Promise<Response<any, Record<string, any>>>;
/**
 * Get customer's orders
 * GET /api/orders/my-orders
 */
export declare const getMyOrders: (req: AuthRequest, res: Response) => Promise<Response<any, Record<string, any>>>;
/**
 * Update order status (Admin only)
 * PUT /api/orders/:id/status
 */
export declare const updateOrderStatus: (req: AuthRequest, res: Response) => Promise<Response<any, Record<string, any>>>;
/**
 * Cancel order
 * PUT /api/orders/:id/cancel
 */
export declare const cancelOrder: (req: AuthRequest, res: Response) => Promise<Response<any, Record<string, any>>>;
export declare const updatePaymentStatus: (req: AuthRequest, res: Response) => Promise<Response<any, Record<string, any>> | undefined>;
//# sourceMappingURL=order.controller.d.ts.map