// Note: In a real DI system we'd inject this. For now we might need to export the instance from server.ts
// OR we attach it to req.app.locals
// But typically for this codebase we can attach it to the Express app.
export const getPlugins = async (req, res) => {
    try {
        // Access plugin manager from app locals (we will set this in server.ts)
        const pluginManager = req.app.get('pluginManager');
        if (!pluginManager) {
            return res.status(500).json({ success: false, error: 'Plugin Manager not initialized' });
        }
        const plugins = pluginManager.getPlugins().map(p => ({
            name: p.name,
            version: p.version,
            status: 'ACTIVE', // All registered are active for now
            description: 'Core Plugin' // Placeholder
        }));
        res.json({
            success: true,
            data: plugins
        });
    }
    catch (error) {
        console.error('Get plugins error:', error);
        res.status(500).json({ success: false, error: 'Failed to fetch plugins' });
    }
};
export const togglePlugin = async (req, res) => {
    res.status(501).json({ success: false, message: 'Plugin toggling not implemented yet' });
};
//# sourceMappingURL=plugin.controller.js.map