import { Request, Response, NextFunction } from 'express';
import { AuthRequest } from '../middleware/auth.js';
/**
 * Get all products with pagination and filters
 */
export declare const getAllProducts: (req: Request, res: Response, next: NextFunction) => Promise<void>;
/**
 * Get product by ID
 */
export declare const getProductById: (req: Request, res: Response, next: NextFunction) => Promise<Response<any, Record<string, any>> | undefined>;
/**
 * Create new product
 */
export declare const createProduct: (req: AuthRequest, res: Response, next: NextFunction) => Promise<Response<any, Record<string, any>> | undefined>;
/**
 * Update product
 */
export declare const updateProduct: (req: AuthRequest, res: Response, next: NextFunction) => Promise<Response<any, Record<string, any>> | undefined>;
/**
 * Delete product
 */
export declare const deleteProduct: (req: AuthRequest, res: Response, next: NextFunction) => Promise<Response<any, Record<string, any>> | undefined>;
/**
 * Get products by category
 * Includes products from subcategories if the category is a parent
 */
export declare const getProductsByCategory: (req: Request, res: Response, next: NextFunction) => Promise<Response<any, Record<string, any>> | undefined>;
/**
 * Search products
 */
export declare const searchProducts: (req: Request, res: Response, next: NextFunction) => Promise<Response<any, Record<string, any>> | undefined>;
/**
 * Get featured products
 */
export declare const getFeaturedProducts: (req: Request, res: Response, next: NextFunction) => Promise<void>;
/**
 * Update product stock
 */
export declare const updateProductStock: (req: AuthRequest, res: Response, next: NextFunction) => Promise<Response<any, Record<string, any>> | undefined>;
/**
 * Add product size table entry
 */
export declare const addProductSizeTable: (req: AuthRequest, res: Response, next: NextFunction) => Promise<void>;
/**
 * Update product size table entry
 */
export declare const updateProductSizeTable: (req: AuthRequest, res: Response, next: NextFunction) => Promise<void>;
/**
 * Delete product size table entry
 */
export declare const deleteProductSizeTable: (req: AuthRequest, res: Response, next: NextFunction) => Promise<void>;
//# sourceMappingURL=product.controller.d.ts.map