import { Express } from 'express';
import { HookSystem } from './HookSystem.js';
export interface PluginDefinition {
    name: string;
    version: string;
    init: (app: Express, hooks: HookSystem) => Promise<void>;
}
export declare class PluginManager {
    private plugins;
    private app;
    constructor(app: Express);
    /**
     * Register a plugin manually (later can be auto-discovery)
     */
    register(plugin: PluginDefinition): void;
    /**
     * Initialize all registered plugins
     */
    init(): Promise<PluginDefinition[]>;
}
//# sourceMappingURL=PluginManager.d.ts.map