import { hooks } from './HookSystem.js';
export class PluginManager {
    plugins = [];
    app;
    constructor(app) {
        this.app = app;
    }
    /**
     * Register a plugin manually (later can be auto-discovery)
     */
    register(plugin) {
        this.plugins.push(plugin);
        console.log(`[PluginManager] Registered plugin: ${plugin.name} v${plugin.version}`);
    }
    /**
     * Initialize all registered plugins
     */
    async init() {
        console.log('[PluginManager] Initializing plugins...');
        for (const plugin of this.plugins) {
            try {
                await plugin.init(this.app, hooks);
                console.log(`[PluginManager] initialized: ${plugin.name}`);
            }
            catch (error) {
                console.error(`[PluginManager] Failed to init ${plugin.name}:`, error);
                throw error;
            }
        }
        /**
         * Get list of registered plugins
         */
        getPlugins();
        PluginDefinition[];
        {
            return this.plugins;
        }
    }
}
//# sourceMappingURL=PluginManager.js.map