import * as logic from './logic.js';
export const name = 'tax-tunisia';
export const version = '1.0.0';
export const init = async (_app, hooks) => {
    // Hook: calculate.line_item
    // Context: LineItemInput & { result?: LineItemResult }
    hooks.on('calculate.line_item', async (context, next) => {
        try {
            // Apply Tunisian Tax Logic
            const result = logic.calculateLineItem(context);
            context.result = result;
        }
        catch (error) {
            console.error('[TaxTunisia] Error in calculate.line_item:', error);
            throw error;
        }
        await next();
    });
    // Hook: calculate.document
    // Context: { lineItems: LineItemResult[], result?: DocumentTvaSummary }
    hooks.on('calculate.document', async (context, next) => {
        try {
            const result = logic.calculateDocumentTva(context.lineItems);
            context.result = result;
        }
        catch (error) {
            console.error('[TaxTunisia] Error in calculate.document:', error);
            throw error;
        }
        await next();
    });
    // Hook: tva.get_effective_rate
    // Context: { productId: string, catalogId: string, result?: { rate: number, ... } }
    hooks.on('tva.get_effective_rate', async (context, next) => {
        try {
            const result = await logic.getEffectiveTvaRate(context.productId, context.catalogId);
            context.result = result;
        }
        catch (error) {
            console.error('[TaxTunisia] Error in tva.get_effective_rate:', error);
        }
        await next();
    });
    // Hook: tva.is_exempt
    // Context: { userId: string, isExempt?: boolean }
    hooks.on('tva.is_exempt', async (context, next) => {
        try {
            context.isExempt = await logic.isCustomerTvaExempt(context.userId);
        }
        catch (error) {
            console.error('[TaxTunisia] Error in tva.is_exempt:', error);
        }
        await next();
    });
    console.log('[TaxTunisia] Plugin initialized');
};
//# sourceMappingURL=index.js.map