import { Router } from 'express';
import { getAccountingStats } from '../controllers/accounting.controller.js';
import { authenticate, authorize, PERMISSIONS } from '../middleware/auth.js';
const router = Router();
// All routes require Admin access
router.use(authenticate);
router.use(authorize(...PERMISSIONS.ACCOUNTING_VIEW));
/**
 * @route   GET /api/admin/accounting/stats
 * @desc    Get monthly fiscal statistics
 * @access  Admin
 */
router.get('/stats', getAccountingStats);
export default router;
//# sourceMappingURL=accounting.routes.js.map