import { Router } from 'express';
import { getAllBannerSlides, getAllBannerSlidesAdmin, getBannerSlide, createBannerSlide, updateBannerSlide, deleteBannerSlide, reorderBannerSlides, } from '../controllers/banner.controller';
import { authenticate, authorize, PERMISSIONS } from '../middleware/auth';
const router = Router();
// Public routes
router.get('/', getAllBannerSlides);
router.get('/:id', getBannerSlide);
// Admin routes
router.get('/admin/all', authenticate, authorize(...PERMISSIONS.CATALOG_MANAGE), getAllBannerSlidesAdmin);
router.post('/', authenticate, authorize(...PERMISSIONS.CATALOG_MANAGE), createBannerSlide);
router.put('/:id', authenticate, authorize(...PERMISSIONS.CATALOG_MANAGE), updateBannerSlide);
router.delete('/:id', authenticate, authorize(...PERMISSIONS.CATALOG_MANAGE), deleteBannerSlide);
router.post('/reorder', authenticate, authorize(...PERMISSIONS.CATALOG_MANAGE), reorderBannerSlides);
export default router;
//# sourceMappingURL=banner.routes.js.map