import { Router } from 'express';
import { authenticate, authorize, PERMISSIONS } from '../middleware/auth.js';
import { createCustomer, getAllCustomers, getCustomerById, updateCustomer, deleteCustomer, resetCustomerPassword, } from '../controllers/customer.controller.js';
const router = Router();
// All routes require authentication
router.use(authenticate);
// View routes (Support can view)
router.get('/', authorize(...PERMISSIONS.CUSTOMER_VIEW), getAllCustomers);
router.get('/:id', authorize(...PERMISSIONS.CUSTOMER_VIEW), getCustomerById);
// Manage routes (Sales/Admin only)
router.post('/', authorize(...PERMISSIONS.CUSTOMER_MANAGE), createCustomer);
router.put('/:id', authorize(...PERMISSIONS.CUSTOMER_MANAGE), updateCustomer);
router.delete('/:id', authorize(...PERMISSIONS.CUSTOMER_MANAGE), deleteCustomer);
router.post('/:id/reset-password', authorize(...PERMISSIONS.CUSTOMER_MANAGE), resetCustomerPassword);
export default router;
//# sourceMappingURL=customer.routes.js.map