import express from 'express';
import { createOrder, getAllOrders, getOrderById, getMyOrders, updateOrderStatus, cancelOrder, updatePaymentStatus, } from '../controllers/order.controller';
import { authenticate, authorize, PERMISSIONS } from '../middleware/auth.js';
const router = express.Router();
/**
 * Customer routes (authenticated customers)
 */
// Get customer's own orders (must be before GET /)
router.get('/my-orders', authenticate, getMyOrders);
// Create new order (authenticated customers)
router.post('/', authenticate, createOrder);
// Cancel order (customer can cancel their own pending orders)
router.put('/:id/cancel', authenticate, cancelOrder);
/**
 * Admin routes (admin/manager only)
 */
// Get all orders (admin only) - must be before GET /:id
router.get('/', authenticate, authorize(...PERMISSIONS.SALES_VIEW), getAllOrders);
// Update order status (admin only)
router.put('/:id/status', authenticate, authorize(...PERMISSIONS.SALES_MANAGE), updateOrderStatus);
// Update payment status (admin only)
router.put('/:id/payment-status', authenticate, authorize(...PERMISSIONS.SALES_MANAGE), updatePaymentStatus);
// Get specific order (customer can only see their own, admin can see all)
router.get('/:id', authenticate, getOrderById);
export default router;
//# sourceMappingURL=order.routes.js.map