import express from 'express';
import { createQuotation, getAllQuotations, getQuotationById, submitQuotation, updateQuotation, approveQuotation, declineQuotation, deleteQuotation, } from '../controllers/quotation.controller';
import { authenticate, authorize, PERMISSIONS } from '../middleware/auth';
const router = express.Router();
// All routes require authentication
router.use(authenticate);
// Customer routes
router.post('/', createQuotation); // Create draft quotation
router.get('/', getAllQuotations); // List quotations (filtered by role)
router.get('/:id', getQuotationById); // Get quotation details
router.post('/:id/submit', submitQuotation); // Submit for approval
router.delete('/:id', deleteQuotation); // Delete draft
// Admin/Manager routes
router.put('/:id', authorize(...PERMISSIONS.SALES_MANAGE), updateQuotation); // Update quotation (edit items/quantities)
router.put('/:id/approve', authorize(...PERMISSIONS.SALES_MANAGE), approveQuotation); // Approve & convert to order
router.put('/:id/decline', authorize(...PERMISSIONS.SALES_MANAGE), declineQuotation); // Decline quotation
export default router;
//# sourceMappingURL=quotation.routes.js.map