import { Prisma } from '@prisma/client';
import type { SupplierInventory, CustomerInventory, StockTransaction, OrderItem } from '@prisma/client';
export interface InventoryReport {
    totalItems: number;
    totalValue: number;
    lowStockItems?: number;
}
export interface TransferResult {
    success: boolean;
    message: string;
    transactions?: StockTransaction[];
    errors?: string[];
}
export interface ValidationResult {
    isValid: boolean;
    outOfStockItems: {
        productId: string;
        productName: string;
        requested: number;
        available: number;
    }[];
}
export declare class InventoryService {
    /**
     * Get current stock level for a product
     */
    checkSupplierStock(productId: string): Promise<number>;
    /**
   * Add stock to supplier inventory (Purchase, Adjustment, Returns)
   */
    addSupplierStock(productId: string, quantity: number, notes?: string, type?: any): Promise<SupplierInventory>;
    /**
     * Deduct stock from supplier inventory
     */
    deductSupplierStock(productId: string, quantity: number, referenceId?: string, notes?: string): Promise<SupplierInventory>;
    /**
     * Get products below reorder level
     */
    getLowStockProducts(threshold?: number): Promise<any[]>;
    /**
     * Get customer's inventory
     */
    getCustomerInventory(customerId: string): Promise<CustomerInventory[]>;
    /**
     * Add to customer inventory (usually from order delivery)
     */
    addToCustomerInventory(customerId: string, productId: string, quantity: number, sourceOrderId: string): Promise<CustomerInventory>;
    /**
     * Validates if we can fulfill an order
     */
    validateOrderStock(orderItems: OrderItem[]): Promise<ValidationResult>;
    /**
     * CORE: Process stock transfer for an Order
     * Deducts from Supplier -> Adds to Customer
     */
    processOrderStockTransfer(orderId: string): Promise<TransferResult>;
    /**
     * Get transaction history
     */
    getStockTransactionHistory(filters: any): Promise<({
        product: {
            id: string;
            isActive: boolean;
            tvaExempt: boolean;
            tvaExemptReason: string | null;
            createdAt: Date;
            updatedAt: Date;
            name: string;
            slug: string;
            description: string | null;
            catalogId: string | null;
            categoryId: string;
            shortDescription: string | null;
            sku: string | null;
            brand: string | null;
            basePrice: Prisma.Decimal;
            costPrice: Prisma.Decimal;
            fodecSubject: boolean;
            tvaRate: Prisma.Decimal;
            hasDiscount: boolean;
            discountType: string | null;
            discountValue: Prisma.Decimal | null;
            discountStartDate: Date | null;
            discountEndDate: Date | null;
            stockQuantity: number;
            isFeatured: boolean;
            trackInventory: boolean;
        };
    } & {
        id: string;
        createdAt: Date;
        productId: string;
        type: import(".prisma/client").$Enums.StockTransactionType;
        quantity: number;
        fromLocationType: import(".prisma/client").$Enums.StockLocationType | null;
        fromLocationId: string | null;
        toLocationType: import(".prisma/client").$Enums.StockLocationType | null;
        toLocationId: string | null;
        referenceId: string | null;
        notes: string | null;
    })[]>;
}
export declare const inventoryService: InventoryService;
//# sourceMappingURL=inventory.service.d.ts.map