import { Request } from 'express';
import { PrismaClient } from '@prisma/client';
export interface CatalogContext {
    id: string;
    slug: string;
    name: string;
    isDefault: boolean;
}
interface CatalogContextOptions {
    required?: boolean;
    fallbackToDefault?: boolean;
    allowBody?: boolean;
    useCustomerAssignment?: boolean;
    requireCustomerAssignment?: boolean;
}
export declare const ensureCustomerAssignedToCatalog: (prisma: PrismaClient, customerId: string, catalogId: string) => Promise<{
    id: string;
    catalogId: string;
    customerId: string;
    canOrder: boolean;
    canQuote: boolean;
    assignedAt: Date;
    assignedBy: string | null;
}>;
export declare const resolveCatalogContext: (req: Request, prisma: PrismaClient, options?: CatalogContextOptions) => Promise<CatalogContext>;
export {};
//# sourceMappingURL=catalogContext.d.ts.map