import { Decimal } from '@prisma/client/runtime/library';
export interface FiscalItem {
    unitPrice: number | Decimal;
    quantity: number;
    tvaRate: number | Decimal;
    discount?: number | Decimal;
}
export interface FiscalTotals {
    totalHT: number;
    totalTVA: number;
    totalTTC: number;
    netMargin?: number;
}
/**
 * Calculates fiscal totals for a list of items.
 * Handles Decimal or number inputs safely.
 */
export declare const calculateFiscalTotals: (items: FiscalItem[], timbreFiscal?: number) => FiscalTotals;
/**
 * Calculates margin for a single product sale
 */
export declare const calculateMargin: (sellingPriceHT: number, costPrice: number, quantity: number) => number;
//# sourceMappingURL=fiscal.d.ts.map