import * as RBT from "./internal/redBlackTree.js";
import * as RBTI from "./internal/redBlackTree/iterator.js";
const TypeId = RBT.RedBlackTreeTypeId;
/**
 * @since 2.0.0
 * @category constants
 */
export const Direction = RBTI.Direction;
/**
 * @since 2.0.0
 * @category refinements
 */
export const isRedBlackTree = RBT.isRedBlackTree;
/**
 * Creates an empty `RedBlackTree`.
 *
 * @since 2.0.0
 * @category constructors
 */
export const empty = RBT.empty;
/**
 * Creates a new `RedBlackTree` from an iterable collection of key/value pairs.
 *
 * @since 2.0.0
 * @category constructors
 */
export const fromIterable = RBT.fromIterable;
/**
 * Constructs a new `RedBlackTree` from the specified entries.
 *
 * @since 2.0.0
 * @category constructors
 */
export const make = RBT.make;
/**
 * Returns an iterator that points to the element at the specified index of the
 * tree.
 *
 * **Note**: The iterator will run through elements in order.
 *
 * @since 2.0.0
 * @category traversing
 */
export const at = RBT.atForwards;
/**
 * Returns an iterator that points to the element at the specified index of the
 * tree.
 *
 * **Note**: The iterator will run through elements in reverse order.
 *
 * @since 2.0.0
 * @category traversing
 */
export const atReversed = RBT.atBackwards;
/**
 * Finds all values in the tree associated with the specified key.
 *
 * @since 2.0.0
 * @category elements
 */
export const findAll = RBT.findAll;
/**
 * Finds the first value in the tree associated with the specified key, if it exists.
 *
 * @category elements
 * @since 2.0.0
 */
export const findFirst = RBT.findFirst;
/**
 * Returns the first entry in the tree, if it exists.
 *
 * @since 2.0.0
 * @category getters
 */
export const first = RBT.first;
/**
 * Returns the element at the specified index within the tree or `None` if the
 * specified index does not exist.
 *
 * @since 2.0.0
 * @category elements
 */
export const getAt = RBT.getAt;
/**
 * Gets the `Order<K>` that the `RedBlackTree<K, V>` is using.
 *
 * @since 2.0.0
 * @category getters
 */
export const getOrder = RBT.getOrder;
/**
 * Returns an iterator that traverse entries in order with keys greater than the
 * specified key.
 *
 * @since 2.0.0
 * @category traversing
 */
export const greaterThan = RBT.greaterThanForwards;
/**
 * Returns an iterator that traverse entries in reverse order with keys greater
 * than the specified key.
 *
 * @since 2.0.0
 * @category traversing
 */
export const greaterThanReversed = RBT.greaterThanBackwards;
/**
 * Returns an iterator that traverse entries in order with keys greater than or
 * equal to the specified key.
 *
 * @since 2.0.0
 * @category traversing
 */
export const greaterThanEqual = RBT.greaterThanEqualForwards;
/**
 * Returns an iterator that traverse entries in reverse order with keys greater
 * than or equal to the specified key.
 *
 * @since 2.0.0
 * @category traversing
 */
export const greaterThanEqualReversed = RBT.greaterThanEqualBackwards;
/**
 * Finds the item with key, if it exists.
 *
 * @since 2.0.0
 * @category elements
 */
export const has = RBT.has;
/**
 * Insert a new item into the tree.
 *
 * @since 2.0.0
 */
export const insert = RBT.insert;
/**
 * Get all the keys present in the tree in order.
 *
 * @since 2.0.0
 * @category getters
 */
export const keys = RBT.keysForward;
/**
 * Get all the keys present in the tree in reverse order.
 *
 * @since 2.0.0
 * @category getters
 */
export const keysReversed = RBT.keysBackward;
/**
 * Returns the last entry in the tree, if it exists.
 *
 * @since 2.0.0
 * @category getters
 */
export const last = RBT.last;
/**
 * Returns an iterator that traverse entries in order with keys less than the
 * specified key.
 *
 * @since 2.0.0
 * @category traversing
 */
export const lessThan = RBT.lessThanForwards;
/**
 * Returns an iterator that traverse entries in reverse order with keys less
 * than the specified key.
 *
 * @since 2.0.0
 * @category traversing
 */
export const lessThanReversed = RBT.lessThanBackwards;
/**
 * Returns an iterator that traverse entries in order with keys less than or
 * equal to the specified key.
 *
 * @since 2.0.0
 * @category traversing
 */
export const lessThanEqual = RBT.lessThanEqualForwards;
/**
 * Returns an iterator that traverse entries in reverse order with keys less
 * than or equal to the specified key.
 *
 * @since 2.0.0
 * @category traversing
 */
export const lessThanEqualReversed = RBT.lessThanEqualBackwards;
/**
 * Execute the specified function for each node of the tree, in order.
 *
 * @since 2.0.0
 * @category traversing
 */
export const forEach = RBT.forEach;
/**
 * Visit each node of the tree in order with key greater then or equal to max.
 *
 * @since 2.0.0
 * @category traversing
 */
export const forEachGreaterThanEqual = RBT.forEachGreaterThanEqual;
/**
 * Visit each node of the tree in order with key lower then max.
 *
 * @since 2.0.0
 * @category traversing
 */
export const forEachLessThan = RBT.forEachLessThan;
/**
 * Visit each node of the tree in order with key lower than max and greater
 * than or equal to min.
 *
 * @since 2.0.0
 * @category traversing
 */
export const forEachBetween = RBT.forEachBetween;
/**
 * Reduce a state over the entries of the tree.
 *
 * @since 2.0.0
 * @category folding
 */
export const reduce = RBT.reduce;
/**
 * Removes the entry with the specified key, if it exists.
 *
 * @since 2.0.0
 */
export const removeFirst = RBT.removeFirst;
/**
 * Traverse the tree in reverse order.
 *
 * @since 2.0.0
 * @category traversing
 */
export const reversed = RBT.reversed;
/**
 * Returns the size of the tree.
 *
 * @since 2.0.0
 * @category getters
 */
export const size = RBT.size;
/**
 * Get all values present in the tree in order.
 *
 * @since 2.0.0
 * @category getters
 */
export const values = RBT.valuesForward;
/**
 * Get all values present in the tree in reverse order.
 *
 * @since 2.0.0
 * @category getters
 */
export const valuesReversed = RBT.valuesBackward;
//# sourceMappingURL=RedBlackTree.js.map