import { PrismaClient } from '@prisma/client';

const prisma = new PrismaClient();

async function main() {
    console.log('Checking for default catalog...');

    const defaultCatalog = await prisma.catalog.findFirst({
        where: { isDefault: true },
    });

    if (defaultCatalog) {
        console.log(`Default catalog found: ${defaultCatalog.name} (${defaultCatalog.id})`);
        return;
    }

    console.log('No default catalog found. Checking for any catalog...');

    const anyCatalog = await prisma.catalog.findFirst();

    if (anyCatalog) {
        console.log(`Found catalog: ${anyCatalog.name}. Setting as default...`);
        await prisma.catalog.update({
            where: { id: anyCatalog.id },
            data: { isDefault: true },
        });
        console.log('Set as default.');
    } else {
        console.log('No catalogs found. Creating default catalog...');
        const newCatalog = await prisma.catalog.create({
            data: {
                name: 'Default Catalog',
                slug: 'default',
                description: 'Default catalog for public users',
                isDefault: true,
                isActive: true,
            },
        });
        console.log(`Created default catalog: ${newCatalog.name} (${newCatalog.id})`);
    }
}

main()
    .catch((e) => {
        console.error(e);
        process.exit(1);
    })
    .finally(async () => {
        await prisma.$disconnect();
    });
