// French translations for the entire application
export const fr = {
  // Common
  common: {
    loading: 'Chargement...',
    error: 'Erreur',
    success: 'Succès',
    cancel: 'Annuler',
    confirm: 'Confirmer',
    save: 'Enregistrer',
    delete: 'Supprimer',
    edit: 'Modifier',
    view: 'Voir',
    back: 'Retour',
    next: 'Suivant',
    previous: 'Précédent',
    search: 'Rechercher',
    filter: 'Filtrer',
    sort: 'Trier',
    close: 'Fermer',
    submit: 'Soumettre',
    add: 'Ajouter',
    remove: 'Retirer',
    update: 'Mettre à jour',
    yes: 'Oui',
    no: 'Non',
  },

  // Header
  header: {
    title: 'SMD Quincaillerie',
    cart: 'Panier',
    account: 'Compte',
    menu: 'Menu',
  },

  // Sidebar/Navigation
  nav: {
    home: 'Accueil',
    categories: 'Catégories',
    products: 'Produits',
    cart: 'Panier',
    account: 'Mon Compte',
    orders: 'Mes Commandes',
    quotations: 'Mes Devis',
    invoices: 'Mes Factures',
    logout: 'Déconnexion',
    login: 'Connexion',
  },

  // Login Screen
  login: {
    title: 'Connexion',
    subtitle: 'Connectez-vous à votre compte',
    username: 'Nom d\'utilisateur',
    password: 'Mot de passe',
    loginButton: 'Se connecter',
    loggingIn: 'Connexion en cours...',
    error: 'Nom d\'utilisateur ou mot de passe incorrect',
    required: 'Ce champ est requis',
  },

  // Home Screen
  home: {
    welcome: 'Bienvenue',
    searchPlaceholder: 'Rechercher des outils, matériaux ou marques…',
    featuredCategories: 'Catégories en vedette',
    featuredProducts: 'Produits en vedette',
    viewAllCategories: 'Voir toutes les catégories',
    allCategories: 'Toutes les catégories',
    viewAll: 'Voir tout',
    noCategories: 'Aucune catégorie disponible',
    whyChooseUs: 'Pourquoi nous choisir?',
    qualityProducts: 'Produits exclusivement professionnels',
    qualityProductsDesc: 'Conçus et sélectionnés pour répondre aux exigences techniques et opérationnelles des entreprises.',
    highRatings: 'Partenaires de confiance',
    highRatingsDesc: 'Des retours clients vérifiés qui reflètent des relations B2B durables et fiables.',
    freeDelivery: 'Logistique optimisée B2B',
    freeDeliveryDesc: 'Livraison gratuite pour toutes les commandes professionnelles, avec des délais maîtrisés.',
    goodSupport: 'Support dédié aux comptes entreprises',
    goodSupportDesc: 'Un accompagnement expert, fiable et réactif pour toutes vos demandes commerciales et techniques.',
    searchResults: 'Résultats de recherche',
  },

  // Product List
  products: {
    title: 'Produits',
    noProducts: 'Aucun produit disponible',
    addToCart: 'Ajouter au panier',
    outOfStock: 'Rupture de stock',
    inStock: 'En stock',
    price: 'Prix',
    quantity: 'Quantité',
    total: 'Total',
  },

  // Product Detail
  productDetail: {
    description: 'Description',
    specifications: 'Spécifications',
    addToCart: 'Ajouter au panier',
    quantity: 'Quantité',
    stock: 'Stock disponible',
    sku: 'Référence',
    category: 'Catégorie',
    price: 'Prix',
  },

  // Cart/Basket
  cart: {
    title: 'Mon Panier',
    empty: 'Votre panier est vide',
    emptyMessage: 'Commencez vos achats pour ajouter des articles',
    continueShopping: 'Continuer mes achats',
    checkout: 'Passer la commande',
    subtotal: 'Sous-total',
    tax: 'TVA (19%)',
    delivery: 'Livraison',
    total: 'Total',
    remove: 'Retirer',
    updateQuantity: 'Modifier la quantité',
    itemsInCart: 'articles dans le panier',
  },

  // Checkout
  checkout: {
    title: 'Finaliser la commande',
    customerInfo: 'Informations client',
    paymentMethod: 'Mode de paiement',
    paymentConditions: 'Modalité de paiement',
    paymentTerms: 'Conditions de paiement',
    orderSummary: 'Récapitulatif de la commande',
    quotationSummary: 'Récapitulatif du devis',
    placeOrder: 'Passer la commande',
    submitQuotation: 'Soumettre le devis',
    processing: 'Traitement en cours...',
    cash: 'Espèces',
    card: 'Carte bancaire',
    netTerms: 'Conditions de paiement',
    subtotal: 'Sous-total',
    tax: 'TVA',
    delivery: 'Livraison',
    total: 'Total',
    emptyCart: 'Votre panier est vide',
    loginRequired: 'Veuillez vous connecter pour passer une commande',
    assignedPaymentConditions: 'Conditions de paiement attribuées',
    paymentMethodLabel: 'Mode de paiement',
    paymentTermsLabel: 'Conditions de paiement',
    creditLimit: 'Limite de crédit',
    currentOutstanding: 'Encours actuel',
    accountStatus: 'Statut du compte',
    quotationRequiresApproval: 'Votre devis nécessitera l\'approbation de l\'administrateur avant traitement.',
    creditLimitExceeded: 'Limite de crédit dépassée',
    creditLimitExceededMessage: 'Ce devis dépassera votre limite de crédit. L\'approbation de l\'administrateur est requise.',
    newOutstanding: 'Nouvel encours',
    limit: 'Limite',
    cashOnDelivery: 'Paiement à la livraison',
    cashOnDeliveryDesc: 'Payez à la réception de votre commande',
    cardPayment: 'Paiement par carte',
    cardPaymentDesc: 'Payez avec votre carte de crédit/débit',
    backToCart: 'Retour au panier',
    shippingAddress: 'Adresse de livraison',
    errors: {
      emptyCart: 'Votre panier est vide',
      fillRequired: 'Veuillez remplir tous les champs obligatoires',
      accountSuspended: 'Votre compte est suspendu',
      creditLimit: 'Limite de crédit insuffisante',
    },
  },

  // Order Confirmation
  orderConfirmation: {
    title: 'Commande confirmée',
    quotationTitle: 'Devis soumis',
    thankYou: 'Merci pour votre commande!',
    quotationThankYou: 'Merci pour votre demande de devis!',
    orderNumber: 'Numéro de commande',
    quotationNumber: 'Numéro de devis',
    orderPlaced: 'Votre commande a été passée avec succès',
    quotationSubmitted: 'Votre devis a été soumis pour approbation',
    quotationPending: 'Votre devis est en attente d\'approbation par notre équipe',
    quotationApproval: 'Vous serez notifié une fois le devis approuvé',
    viewQuotations: 'Voir mes devis',
    backToHome: 'Retour à l\'accueil',
    customerInfo: 'Informations client',
    orderDetails: 'Détails de la commande',
    quotationDetails: 'Détails du devis',
    paymentMethod: 'Mode de paiement',
    status: 'Statut',
  },

  // Account Screen
  account: {
    title: 'Mon Compte',
    profile: 'Profil',
    orders: 'Commandes',
    quotations: 'Devis',
    invoices: 'Factures',
    wishlist: 'Liste de souhaits',
    addresses: 'Adresses',
    settings: 'Paramètres',
    logout: 'Déconnexion',
    personalInfo: 'Informations personnelles',
    businessInfo: 'Informations professionnelles',
    financialInfo: 'Informations financières',
    name: 'Nom',
    email: 'Email',
    phone: 'Téléphone',
    company: 'Entreprise',
    taxId: 'Numéro TVA',
    creditLimit: 'Limite de crédit',
    currentOutstanding: 'Encours actuel',
    availableCredit: 'Crédit disponible',
    paymentTerm: 'Conditions de paiement',
    accountStatus: 'Statut du compte',
    viewQuotations: 'Voir mes devis',
    viewInvoices: 'Voir mes factures',
    noOrders: 'Aucune commande',
    noQuotations: 'Aucun devis',
    quotationsMessage: 'Soumettez des devis pour les voir ici',
    noInvoices: 'Aucune facture',
    invoicesMessage: 'Vos factures apparaîtront ici une fois les commandes expédiées',
    noOrdersMessage: 'Commencez vos achats pour voir vos commandes ici',
    startShopping: 'Commencer mes achats',
    wishlistEmpty: 'Votre liste de souhaits est vide',
    wishlistMessage: 'Enregistrez les articles que vous aimez pour plus tard',
    noAddresses: 'Aucune adresse enregistrée',
    addressesMessage: 'Ajoutez une adresse pour un paiement plus rapide',
    addAddress: 'Ajouter une nouvelle adresse',
    savedAddresses: 'Adresses enregistrées',
  },

  // My Quotations
  quotations: {
    title: 'Mes Devis',
    subtitle: 'Voir et gérer vos devis',
    noQuotations: 'Aucun devis',
    noQuotationsMessage: 'Les devis apparaîtront ici une fois que vous en aurez soumis',
    quotationNumber: 'Numéro de devis',
    date: 'Date',
    status: 'Statut',
    amount: 'Montant',
    viewDetails: 'Voir les détails',
    pending: 'En attente',
    approved: 'Approuvé',
    declined: 'Refusé',
    converted: 'Converti en commande',
    expired: 'Expiré',
    draft: 'Brouillon',
    pendingApproval: 'En attente d\'approbation',
    items: 'Articles',
    subtotal: 'Sous-total',
    tax: 'TVA',
    total: 'Total',
    notes: 'Notes',
    createdAt: 'Créé le',
    updatedAt: 'Mis à jour le',
  },

  // My Invoices
  invoices: {
    title: 'Mes Factures',
    subtitle: 'Voir et gérer vos factures',
    noInvoices: 'Aucune facture',
    noInvoicesMessage: 'Les factures apparaîtront ici une fois que vos commandes seront expédiées ou livrées',
    backToAccount: 'Retour au compte',
    invoiceNumber: 'Numéro de facture',
    issuedDate: 'Date d\'émission',
    dueDate: 'Date d\'échéance',
    amount: 'Montant',
    status: 'Statut',
    paymentTerms: 'Conditions de paiement',
    overdue: 'En retard',
    overdueMessage: 'Cette facture est en retard',
    issued: 'Émise',
    paid: 'Payée',
    cancelled: 'Annulée',
    draft: 'Brouillon',
    paymentReceived: 'Paiement reçu',
    paidOn: 'Payé le',
    financialSummary: 'Récapitulatif financier',
    subtotal: 'Sous-total',
    tax: 'TVA (19%)',
    total: 'Total',
    invoiceDetails: 'Détails de la facture',
  },

  // Status
  status: {
    pending: 'En attente',
    processing: 'En cours',
    shipped: 'Expédié',
    delivered: 'Livré',
    cancelled: 'Annulé',
    approved: 'Approuvé',
    declined: 'Refusé',
    active: 'Actif',
    inactive: 'Inactif',
  },

  // Payment Methods
  payment: {
    cash: 'Espèces',
    card: 'Carte bancaire',
    netTerms: 'Conditions de paiement',
    net30: 'Net 30 jours',
    net60: 'Net 60 jours',
    net90: 'Net 90 jours',
    net120: 'Net 120 jours',
    immediate: 'Immédiat',
  },

  // Errors
  errors: {
    generic: 'Une erreur s\'est produite',
    network: 'Erreur de connexion',
    unauthorized: 'Non autorisé',
    notFound: 'Non trouvé',
    serverError: 'Erreur serveur',
    invalidInput: 'Entrée invalide',
    required: 'Ce champ est requis',
  },

  // Success Messages
  success: {
    orderPlaced: 'Commande passée avec succès',
    quotationSubmitted: 'Devis soumis avec succès',
    updated: 'Mis à jour avec succès',
    deleted: 'Supprimé avec succès',
    saved: 'Enregistré avec succès',
  },

  // Admin Dashboard
  admin: {
    dashboard: 'Tableau de bord',
    customers: 'Clients',
    products: 'Produits',
    categories: 'Catégories',
    orders: 'Commandes',
    quotations: 'Devis',
    invoices: 'Factures',
    reports: 'Rapports',
    settings: 'Paramètres',
    logout: 'Déconnexion',

    // Quotation Management
    quotationManagement: 'Gestion des devis',
    allQuotations: 'Tous les devis',
    filterByStatus: 'Filtrer par statut',
    searchQuotations: 'Rechercher des devis',
    approve: 'Approuver',
    decline: 'Refuser',
    edit: 'Modifier',
    approveConfirm: 'Êtes-vous sûr de vouloir approuver ce devis et le convertir en commande?',
    declineConfirm: 'Êtes-vous sûr de vouloir refuser ce devis?',
    declineReason: 'Raison du refus',
    quotationApproved: 'Devis approuvé et converti en commande avec succès!',
    quotationDeclined: 'Devis refusé avec succès',
    quotationUpdated: 'Devis mis à jour avec succès',

    // Customer Info
    customerInfo: 'Informations client',
    customerName: 'Nom du client',
    customerEmail: 'Email du client',
    customerPhone: 'Téléphone du client',
    companyName: 'Nom de l\'entreprise',

    // Financial
    creditLimit: 'Limite de crédit',
    currentOutstanding: 'Encours actuel',
    anticipatedOutstanding: 'Encours anticipé',
    availableCredit: 'Crédit disponible',
    creditAlert: 'Alerte de crédit',
    exceedsLimit: 'Dépasse la limite de crédit',

    // Actions
    viewDetails: 'Voir les détails',
    approveOrder: 'Approuver et créer une commande',
    declineQuotation: 'Refuser le devis',
    editQuotation: 'Modifier le devis',
    deleteQuotation: 'Supprimer le devis',

    // Order Management
    orderManagement: 'Gestion des commandes',
    updateStatus: 'Mettre à jour le statut',
    orderDetails: 'Détails de la commande',
    statusUpdated: 'Statut mis à jour avec succès',
    invoiceGenerated: 'Facture générée avec succès',

    // Invoice Management
    invoiceManagement: 'Gestion des factures',
    updateInvoiceStatus: 'Mettre à jour le statut de la facture',
    markAsPaid: 'Marquer comme payée',
    invoiceStatusUpdated: 'Statut de la facture mis à jour avec succès',
  },

  // Customer Types
  customerTypes: {
    Retailer: 'Détaillant',
    Wholesaler: 'Grossiste',
    Contractor: 'Entrepreneur',
    B2B: 'Client B2B',
    Individual: 'Particulier',
  },

  // Missing Common
  common: {
    loading: 'Chargement...',
    error: 'Erreur',
    success: 'Succès',
    cancel: 'Annuler',
    confirm: 'Confirmer',
    save: 'Enregistrer',
    delete: 'Supprimer',
    edit: 'Modifier',
    view: 'Voir',
    back: 'Retour',
    next: 'Suivant',
    previous: 'Précédent',
    search: 'Rechercher',
    filter: 'Filtrer',
    sort: 'Trier',
    close: 'Fermer',
    submit: 'Soumettre',
    add: 'Ajouter',
    remove: 'Retirer',
    update: 'Mettre à jour',
    yes: 'Oui',
    no: 'Non',
    items: 'articles',
    noCategories: 'Aucune catégorie disponible',
  },

  // Missing Nav
  nav: {
    home: 'Accueil',
    shop: 'Boutique',
    categories: 'Catégories',
    products: 'Produits',
    cart: 'Panier',
    account: 'Mon Compte',
    orders: 'Mes Commandes',
    quotations: 'Mes Devis',
    invoices: 'Mes Factures',
    logout: 'Déconnexion',
    login: 'Connexion',
  },

  // Missing Home
  home: {
    welcome: 'Bienvenue',
    searchPlaceholder: 'Rechercher des produits, catégories...',
    featuredCategories: 'Catégories en vedette',
    browseCategories: 'Parcourir les catégories',
    featuredProducts: 'Produits en vedette',
    viewAllCategories: 'Voir toutes les catégories',
    allCategories: 'Toutes les catégories',
    viewAll: 'Voir tout',
    noCategories: 'Aucune catégorie disponible',
    whyChooseUs: 'Pourquoi nous choisir?',
    qualityProducts: 'Produits exclusivement professionnels',
    qualityProductsDesc: 'Conçus et sélectionnés pour répondre aux exigences techniques et opérationnelles des entreprises.',
    highRatings: 'Partenaires de confiance',
    highRatingsDesc: 'Des retours clients vérifiés qui reflètent des relations B2B durables et fiables.',
    freeDelivery: 'Logistique optimisée B2B',
    freeDeliveryDesc: 'Livraison gratuite pour toutes les commandes professionnelles, avec des délais maîtrisés.',
    goodSupport: 'Support dédié aux comptes entreprises',
    goodSupportDesc: 'Un accompagnement expert, fiable et réactif pour toutes vos demandes commerciales et techniques.',
    searchResults: 'Résultats de recherche',
  },

  // Missing Invoices
  invoices: {
    title: 'Mes Factures',
    subtitle: 'Voir et gérer vos factures',
    noInvoices: 'Aucune facture',
    noInvoicesMessage: 'Les factures apparaîtront ici une fois que vos commandes seront expédiées ou livrées',
    backToAccount: 'Retour au compte',
    invoiceNumber: 'Numéro de facture',
    issuedDate: 'Date d\'émission',
    dueDate: 'Date d\'échéance',
    amount: 'Montant',
    status: 'Statut',
    paymentTerms: 'Conditions de paiement',
    overdue: 'En retard',
    overdueMessage: 'Cette facture est en retard',
    issued: 'Émise',
    paid: 'Payée',
    cancelled: 'Annulée',
    draft: 'Brouillon',
    paymentReceived: 'Paiement reçu',
    paidOn: 'Payé le',
    financialSummary: 'Récapitulatif financier',
    subtotal: 'Sous-total',
    tax: 'TVA (19%)',
    total: 'Total',
    invoiceDetails: 'Détails de la facture',
    product: 'Produit',
    unitPrice: 'Prix unitaire',
    quantity: 'Quantité',
    priceHT: 'Prix HT',
    totalHT: 'Total HT',
    totalTTC: 'TOTAL TTC',
    billingContact: 'Contact de facturation',
    printInvoice: 'Imprimer la facture',
    items: 'Articles',
    noItems: 'Aucun article disponible',
    tva19: 'TVA 19%',
    tva7: 'TVA 7%',
    tva0: 'TVA 0%',
    tva: 'TVA',
  },
};

export default fr;
