
import { PrismaClient } from '@prisma/client';

const prisma = new PrismaClient();

async function checkOrderDetails() {
    const orders = await prisma.order.findMany({
        orderBy: { createdAt: 'desc' },
        take: 5,
        include: {
            items: true
        }
    });

    console.log(JSON.stringify(orders, null, 2));
}

checkOrderDetails()
    .catch(e => console.error(e))
    .finally(() => prisma.$disconnect());
