
/* !!! This is code generated by Prisma. Do not edit directly. !!!
/* eslint-disable */
// biome-ignore-all lint: generated file

Object.defineProperty(exports, "__esModule", { value: true });

const {
  PrismaClientKnownRequestError,
  PrismaClientUnknownRequestError,
  PrismaClientRustPanicError,
  PrismaClientInitializationError,
  PrismaClientValidationError,
  getPrismaClient,
  sqltag,
  empty,
  join,
  raw,
  skip,
  Decimal,
  Debug,
  objectEnumValues,
  makeStrictEnum,
  Extensions,
  warnOnce,
  defineDmmfProperty,
  Public,
  getRuntime,
  createParam,
} = require('@prisma/client/runtime/wasm-engine-edge.js')


const Prisma = {}

exports.Prisma = Prisma
exports.$Enums = {}

/**
 * Prisma Client JS version: 6.19.0
 * Query Engine version: 2ba551f319ab1df4bc874a89965d8b3641056773
 */
Prisma.prismaVersion = {
  client: "6.19.0",
  engine: "2ba551f319ab1df4bc874a89965d8b3641056773"
}

Prisma.PrismaClientKnownRequestError = PrismaClientKnownRequestError;
Prisma.PrismaClientUnknownRequestError = PrismaClientUnknownRequestError
Prisma.PrismaClientRustPanicError = PrismaClientRustPanicError
Prisma.PrismaClientInitializationError = PrismaClientInitializationError
Prisma.PrismaClientValidationError = PrismaClientValidationError
Prisma.Decimal = Decimal

/**
 * Re-export of sql-template-tag
 */
Prisma.sql = sqltag
Prisma.empty = empty
Prisma.join = join
Prisma.raw = raw
Prisma.validator = Public.validator

/**
* Extensions
*/
Prisma.getExtensionContext = Extensions.getExtensionContext
Prisma.defineExtension = Extensions.defineExtension

/**
 * Shorthand utilities for JSON filtering
 */
Prisma.DbNull = objectEnumValues.instances.DbNull
Prisma.JsonNull = objectEnumValues.instances.JsonNull
Prisma.AnyNull = objectEnumValues.instances.AnyNull

Prisma.NullTypes = {
  DbNull: objectEnumValues.classes.DbNull,
  JsonNull: objectEnumValues.classes.JsonNull,
  AnyNull: objectEnumValues.classes.AnyNull
}





/**
 * Enums
 */
exports.Prisma.TransactionIsolationLevel = makeStrictEnum({
  ReadUncommitted: 'ReadUncommitted',
  ReadCommitted: 'ReadCommitted',
  RepeatableRead: 'RepeatableRead',
  Serializable: 'Serializable'
});

exports.Prisma.UserScalarFieldEnum = {
  id: 'id',
  email: 'email',
  username: 'username',
  passwordHash: 'passwordHash',
  role: 'role',
  firstName: 'firstName',
  lastName: 'lastName',
  phone: 'phone',
  isActive: 'isActive',
  emailVerified: 'emailVerified',
  companyName: 'companyName',
  rneNumber: 'rneNumber',
  rnePdfUrl: 'rnePdfUrl',
  taxId: 'taxId',
  customerType: 'customerType',
  financialLimit: 'financialLimit',
  currentOutstanding: 'currentOutstanding',
  paymentTerm: 'paymentTerm',
  accountStatus: 'accountStatus',
  tvaExempt: 'tvaExempt',
  tvaExemptReason: 'tvaExemptReason',
  annualTurnover: 'annualTurnover',
  tvaExemptValidUntil: 'tvaExemptValidUntil',
  createdAt: 'createdAt',
  updatedAt: 'updatedAt'
};

exports.Prisma.RefreshTokenScalarFieldEnum = {
  id: 'id',
  token: 'token',
  userId: 'userId',
  expiresAt: 'expiresAt',
  createdAt: 'createdAt'
};

exports.Prisma.AddressScalarFieldEnum = {
  id: 'id',
  userId: 'userId',
  label: 'label',
  street: 'street',
  city: 'city',
  state: 'state',
  postalCode: 'postalCode',
  country: 'country',
  isDefault: 'isDefault'
};

exports.Prisma.CatalogScalarFieldEnum = {
  id: 'id',
  name: 'name',
  slug: 'slug',
  description: 'description',
  logoUrl: 'logoUrl',
  primaryColor: 'primaryColor',
  isActive: 'isActive',
  isDefault: 'isDefault',
  defaultTvaRate: 'defaultTvaRate',
  createdAt: 'createdAt',
  updatedAt: 'updatedAt'
};

exports.Prisma.CatalogCustomerScalarFieldEnum = {
  id: 'id',
  catalogId: 'catalogId',
  customerId: 'customerId',
  canOrder: 'canOrder',
  canQuote: 'canQuote',
  assignedAt: 'assignedAt',
  assignedBy: 'assignedBy'
};

exports.Prisma.CategoryScalarFieldEnum = {
  id: 'id',
  catalogId: 'catalogId',
  name: 'name',
  slug: 'slug',
  description: 'description',
  imageUrl: 'imageUrl',
  parentId: 'parentId',
  displayOrder: 'displayOrder',
  isActive: 'isActive',
  createdAt: 'createdAt',
  updatedAt: 'updatedAt'
};

exports.Prisma.ProductScalarFieldEnum = {
  id: 'id',
  catalogId: 'catalogId',
  name: 'name',
  slug: 'slug',
  description: 'description',
  shortDescription: 'shortDescription',
  sku: 'sku',
  brand: 'brand',
  basePrice: 'basePrice',
  costPrice: 'costPrice',
  fodecSubject: 'fodecSubject',
  tvaRate: 'tvaRate',
  tvaExempt: 'tvaExempt',
  tvaExemptReason: 'tvaExemptReason',
  hasDiscount: 'hasDiscount',
  discountType: 'discountType',
  discountValue: 'discountValue',
  discountStartDate: 'discountStartDate',
  discountEndDate: 'discountEndDate',
  categoryId: 'categoryId',
  stockQuantity: 'stockQuantity',
  isActive: 'isActive',
  isFeatured: 'isFeatured',
  createdAt: 'createdAt',
  updatedAt: 'updatedAt'
};

exports.Prisma.ProductImageScalarFieldEnum = {
  id: 'id',
  productId: 'productId',
  imageUrl: 'imageUrl',
  altText: 'altText',
  displayOrder: 'displayOrder',
  isPrimary: 'isPrimary',
  createdAt: 'createdAt'
};

exports.Prisma.ProductSpecificationScalarFieldEnum = {
  id: 'id',
  productId: 'productId',
  specName: 'specName',
  specValue: 'specValue',
  createdAt: 'createdAt'
};

exports.Prisma.ProductSizeTableScalarFieldEnum = {
  id: 'id',
  productId: 'productId',
  unitType: 'unitType',
  size: 'size',
  price: 'price',
  stockQuantity: 'stockQuantity',
  createdAt: 'createdAt',
  updatedAt: 'updatedAt'
};

exports.Prisma.ProductPackSizeScalarFieldEnum = {
  id: 'id',
  productId: 'productId',
  packType: 'packType',
  packQuantity: 'packQuantity',
  size: 'size',
  unitType: 'unitType',
  price: 'price',
  stockQuantity: 'stockQuantity',
  sku: 'sku',
  createdAt: 'createdAt',
  updatedAt: 'updatedAt'
};

exports.Prisma.CatalogProductTvaScalarFieldEnum = {
  id: 'id',
  catalogId: 'catalogId',
  productId: 'productId',
  tvaRate: 'tvaRate',
  tvaExempt: 'tvaExempt',
  reason: 'reason',
  createdAt: 'createdAt',
  updatedAt: 'updatedAt'
};

exports.Prisma.QuotationScalarFieldEnum = {
  id: 'id',
  quotationNumber: 'quotationNumber',
  userId: 'userId',
  status: 'status',
  totalBrutHT: 'totalBrutHT',
  totalDiscount: 'totalDiscount',
  totalNetHT: 'totalNetHT',
  tva19Amount: 'tva19Amount',
  tva7Amount: 'tva7Amount',
  tva0Amount: 'tva0Amount',
  totalTVA: 'totalTVA',
  netAPayer: 'netAPayer',
  netAPayerWords: 'netAPayerWords',
  customerTvaExempt: 'customerTvaExempt',
  subtotal: 'subtotal',
  taxAmount: 'taxAmount',
  totalAmount: 'totalAmount',
  anticipatedOutstanding: 'anticipatedOutstanding',
  shippingAddressId: 'shippingAddressId',
  shippingAddress: 'shippingAddress',
  adminDecisionReason: 'adminDecisionReason',
  reviewedBy: 'reviewedBy',
  reviewedAt: 'reviewedAt',
  convertedToOrderId: 'convertedToOrderId',
  notes: 'notes',
  createdAt: 'createdAt',
  updatedAt: 'updatedAt'
};

exports.Prisma.QuotationItemScalarFieldEnum = {
  id: 'id',
  quotationId: 'quotationId',
  productId: 'productId',
  productName: 'productName',
  productSku: 'productSku',
  selectedSize: 'selectedSize',
  selectedUnitType: 'selectedUnitType',
  quantity: 'quantity',
  unitPrice: 'unitPrice',
  discount: 'discount',
  totalHT: 'totalHT',
  tvaRate: 'tvaRate',
  tvaAmount: 'tvaAmount',
  totalTTC: 'totalTTC',
  tvaExempt: 'tvaExempt',
  totalPrice: 'totalPrice'
};

exports.Prisma.OrderScalarFieldEnum = {
  id: 'id',
  orderNumber: 'orderNumber',
  userId: 'userId',
  customerName: 'customerName',
  customerEmail: 'customerEmail',
  customerPhone: 'customerPhone',
  shippingAddressId: 'shippingAddressId',
  shippingAddress: 'shippingAddress',
  status: 'status',
  paymentMethod: 'paymentMethod',
  paymentStatus: 'paymentStatus',
  totalBrutHT: 'totalBrutHT',
  totalDiscount: 'totalDiscount',
  totalNetHT: 'totalNetHT',
  tva19Amount: 'tva19Amount',
  tva7Amount: 'tva7Amount',
  tva0Amount: 'tva0Amount',
  totalTVA: 'totalTVA',
  netAPayer: 'netAPayer',
  netAPayerWords: 'netAPayerWords',
  customerTvaExempt: 'customerTvaExempt',
  subtotal: 'subtotal',
  taxAmount: 'taxAmount',
  totalAmount: 'totalAmount',
  notes: 'notes',
  fiscalTotalHT: 'fiscalTotalHT',
  fiscalTotalTVA: 'fiscalTotalTVA',
  timbreFiscal: 'timbreFiscal',
  matriculeFiscal: 'matriculeFiscal',
  quotationId: 'quotationId',
  paymentTerm: 'paymentTerm',
  dueDate: 'dueDate',
  createdAt: 'createdAt',
  updatedAt: 'updatedAt'
};

exports.Prisma.OrderItemScalarFieldEnum = {
  id: 'id',
  orderId: 'orderId',
  productId: 'productId',
  productName: 'productName',
  productSku: 'productSku',
  selectedSize: 'selectedSize',
  selectedUnitType: 'selectedUnitType',
  quantity: 'quantity',
  unitPrice: 'unitPrice',
  discount: 'discount',
  totalHT: 'totalHT',
  tvaRate: 'tvaRate',
  tvaAmount: 'tvaAmount',
  totalTTC: 'totalTTC',
  tvaExempt: 'tvaExempt',
  totalPrice: 'totalPrice'
};

exports.Prisma.OrderStatusHistoryScalarFieldEnum = {
  id: 'id',
  orderId: 'orderId',
  status: 'status',
  notes: 'notes',
  createdAt: 'createdAt'
};

exports.Prisma.BannerSlideScalarFieldEnum = {
  id: 'id',
  catalogId: 'catalogId',
  title: 'title',
  subtitle: 'subtitle',
  buttonText: 'buttonText',
  slideType: 'slideType',
  imageUrl: 'imageUrl',
  backgroundColor: 'backgroundColor',
  textColor: 'textColor',
  linkType: 'linkType',
  linkedProductId: 'linkedProductId',
  linkedCategoryId: 'linkedCategoryId',
  displayOrder: 'displayOrder',
  isActive: 'isActive',
  duration: 'duration',
  createdAt: 'createdAt',
  updatedAt: 'updatedAt'
};

exports.Prisma.AnalyticsScalarFieldEnum = {
  id: 'id',
  date: 'date',
  metric: 'metric',
  value: 'value',
  metadata: 'metadata',
  createdAt: 'createdAt'
};

exports.Prisma.SystemSettingScalarFieldEnum = {
  key: 'key',
  value: 'value',
  group: 'group',
  updatedAt: 'updatedAt'
};

exports.Prisma.SortOrder = {
  asc: 'asc',
  desc: 'desc'
};

exports.Prisma.NullableJsonNullValueInput = {
  DbNull: Prisma.DbNull,
  JsonNull: Prisma.JsonNull
};

exports.Prisma.QueryMode = {
  default: 'default',
  insensitive: 'insensitive'
};

exports.Prisma.NullsOrder = {
  first: 'first',
  last: 'last'
};

exports.Prisma.JsonNullValueFilter = {
  DbNull: Prisma.DbNull,
  JsonNull: Prisma.JsonNull,
  AnyNull: Prisma.AnyNull
};
exports.UserRole = exports.$Enums.UserRole = {
  ADMIN: 'ADMIN',
  SUPER_ADMIN: 'SUPER_ADMIN',
  SALES_ADMIN: 'SALES_ADMIN',
  CATALOG_ADMIN: 'CATALOG_ADMIN',
  ACCOUNTING_ADMIN: 'ACCOUNTING_ADMIN',
  SUPPORT_ADMIN: 'SUPPORT_ADMIN',
  MANAGER: 'MANAGER',
  CUSTOMER: 'CUSTOMER'
};

exports.PaymentTerm = exports.$Enums.PaymentTerm = {
  NET_30: 'NET_30',
  NET_60: 'NET_60',
  NET_90: 'NET_90',
  NET_120: 'NET_120',
  IMMEDIATE: 'IMMEDIATE'
};

exports.AccountStatus = exports.$Enums.AccountStatus = {
  COMMERCIAL_IN_PROCESS: 'COMMERCIAL_IN_PROCESS',
  FINANCIAL_IN_PROCESS: 'FINANCIAL_IN_PROCESS',
  ACTIVE: 'ACTIVE',
  FINANCIAL_NON_CURRENT: 'FINANCIAL_NON_CURRENT',
  SUSPENDED: 'SUSPENDED'
};

exports.QuotationStatus = exports.$Enums.QuotationStatus = {
  DRAFT: 'DRAFT',
  PENDING_APPROVAL: 'PENDING_APPROVAL',
  APPROVED: 'APPROVED',
  DECLINED: 'DECLINED',
  CONVERTED_TO_ORDER: 'CONVERTED_TO_ORDER',
  EXPIRED: 'EXPIRED'
};

exports.OrderStatus = exports.$Enums.OrderStatus = {
  PENDING: 'PENDING',
  PROCESSING: 'PROCESSING',
  SHIPPED: 'SHIPPED',
  DELIVERED: 'DELIVERED',
  CANCELLED: 'CANCELLED',
  REFUNDED: 'REFUNDED'
};

exports.PaymentMethod = exports.$Enums.PaymentMethod = {
  CASH_ON_DELIVERY: 'CASH_ON_DELIVERY',
  BANK_TRANSFER: 'BANK_TRANSFER',
  CREDIT_CARD: 'CREDIT_CARD',
  NET_TERMS: 'NET_TERMS',
  CHEQUE: 'CHEQUE'
};

exports.PaymentStatus = exports.$Enums.PaymentStatus = {
  PENDING: 'PENDING',
  PAID: 'PAID',
  FAILED: 'FAILED',
  REFUNDED: 'REFUNDED'
};

exports.SlideType = exports.$Enums.SlideType = {
  IMAGE: 'IMAGE',
  TEXT: 'TEXT'
};

exports.Prisma.ModelName = {
  User: 'User',
  RefreshToken: 'RefreshToken',
  Address: 'Address',
  Catalog: 'Catalog',
  CatalogCustomer: 'CatalogCustomer',
  Category: 'Category',
  Product: 'Product',
  ProductImage: 'ProductImage',
  ProductSpecification: 'ProductSpecification',
  ProductSizeTable: 'ProductSizeTable',
  ProductPackSize: 'ProductPackSize',
  CatalogProductTva: 'CatalogProductTva',
  Quotation: 'Quotation',
  QuotationItem: 'QuotationItem',
  Order: 'Order',
  OrderItem: 'OrderItem',
  OrderStatusHistory: 'OrderStatusHistory',
  BannerSlide: 'BannerSlide',
  Analytics: 'Analytics',
  SystemSetting: 'SystemSetting'
};
/**
 * Create the Client
 */
const config = {
  "generator": {
    "name": "client",
    "provider": {
      "fromEnvVar": null,
      "value": "prisma-client-js"
    },
    "output": {
      "value": "/home/cube/Documents/to_fix/todix03/11bkp_1012_03tofix_update_gravity/bk11SMD_update_gravity/backend/node_modules/@prisma/client",
      "fromEnvVar": null
    },
    "config": {
      "engineType": "library"
    },
    "binaryTargets": [
      {
        "fromEnvVar": null,
        "value": "debian-openssl-3.0.x",
        "native": true
      }
    ],
    "previewFeatures": [],
    "sourceFilePath": "/home/cube/Documents/to_fix/todix03/11bkp_1012_03tofix_update_gravity/bk11SMD_update_gravity/backend/prisma/schema.prisma"
  },
  "relativeEnvPaths": {
    "rootEnvPath": null,
    "schemaEnvPath": "../../../.env"
  },
  "relativePath": "../../../prisma",
  "clientVersion": "6.19.0",
  "engineVersion": "2ba551f319ab1df4bc874a89965d8b3641056773",
  "datasourceNames": [
    "db"
  ],
  "activeProvider": "postgresql",
  "inlineDatasources": {
    "db": {
      "url": {
        "fromEnvVar": "DATABASE_URL",
        "value": null
      }
    }
  },
  "inlineSchema": "// Prisma Schema for SQB Hardware Store\n\ngenerator client {\n  provider = \"prisma-client-js\"\n}\n\ndatasource db {\n  provider = \"postgresql\"\n  url      = env(\"DATABASE_URL\")\n}\n\n// ============================================\n// USER MANAGEMENT\n// ============================================\n\nenum UserRole {\n  ADMIN\n  SUPER_ADMIN\n  SALES_ADMIN\n  CATALOG_ADMIN\n  ACCOUNTING_ADMIN\n  SUPPORT_ADMIN\n  MANAGER\n  CUSTOMER\n}\n\nenum PaymentTerm {\n  NET_30 // 30 days\n  NET_60 // 60 days\n  NET_90 // 90 days\n  NET_120 // 120 days\n  IMMEDIATE // Cash on delivery\n}\n\nenum AccountStatus {\n  COMMERCIAL_IN_PROCESS // New customer, under review\n  FINANCIAL_IN_PROCESS // Approved for ordering, credit being set up\n  ACTIVE // Fully approved, can place orders\n  FINANCIAL_NON_CURRENT // Overdue payments, restricted\n  SUSPENDED // Account suspended\n}\n\nmodel User {\n  id            String   @id @default(uuid())\n  email         String   @unique\n  username      String?  @unique\n  passwordHash  String   @map(\"password_hash\")\n  role          UserRole @default(CUSTOMER)\n  firstName     String?  @map(\"first_name\")\n  lastName      String?  @map(\"last_name\")\n  phone         String?\n  isActive      Boolean  @default(true) @map(\"is_active\")\n  emailVerified Boolean  @default(false) @map(\"email_verified\")\n\n  // Business/Commercial Information (Tunisia)\n  companyName  String? @map(\"company_name\")\n  rneNumber    String? @unique @map(\"rne_number\") // Commercial Registration Number\n  rnePdfUrl    String? @map(\"rne_pdf_url\") // PDF of RNE document\n  taxId        String? @map(\"tax_id\") // Tax Identification Number\n  customerType String? @map(\"customer_type\") // e.g., \"Retailer\", \"Wholesaler\", \"Contractor\"\n\n  // B2B Financial Fields\n  financialLimit     Decimal?      @default(0) @map(\"financial_limit\") @db.Decimal(10, 2)\n  currentOutstanding Decimal?      @default(0) @map(\"current_outstanding\") @db.Decimal(10, 2)\n  paymentTerm        PaymentTerm?  @map(\"payment_term\")\n  accountStatus      AccountStatus @default(COMMERCIAL_IN_PROCESS) @map(\"account_status\")\n\n  // TVA Exemption Fields (Tunisian Tax System)\n  tvaExempt           Boolean   @default(false) @map(\"tva_exempt\") // Customer-level exemption\n  tvaExemptReason     String?   @map(\"tva_exempt_reason\") // e.g., \"Annual turnover < 100,000 TND\"\n  annualTurnover      Decimal?  @map(\"annual_turnover\") @db.Decimal(15, 2) // For compliance tracking\n  tvaExemptValidUntil DateTime? @map(\"tva_exempt_valid_until\") // Exemption expiry date\n\n  createdAt DateTime @default(now()) @map(\"created_at\")\n  updatedAt DateTime @updatedAt @map(\"updated_at\")\n\n  // Relations\n  orders             Order[]\n  addresses          Address[]\n  refreshTokens      RefreshToken[]\n  quotations         Quotation[]\n  reviewedQuotations Quotation[]       @relation(\"ReviewedQuotations\")\n  catalogAssignments CatalogCustomer[] // Catalogs assigned to this customer\n  assignedCatalogs   CatalogCustomer[] @relation(\"AssignedCatalogs\") // Catalogs assigned by this admin\n\n  @@map(\"users\")\n}\n\nmodel RefreshToken {\n  id        String   @id @default(uuid())\n  token     String   @unique\n  userId    String   @map(\"user_id\")\n  expiresAt DateTime @map(\"expires_at\")\n  createdAt DateTime @default(now()) @map(\"created_at\")\n\n  user User @relation(fields: [userId], references: [id], onDelete: Cascade)\n\n  @@map(\"refresh_tokens\")\n}\n\nmodel Address {\n  id         String  @id @default(uuid())\n  userId     String  @map(\"user_id\")\n  label      String? // \"Home\", \"Work\", etc.\n  street     String\n  city       String\n  state      String?\n  postalCode String? @map(\"postal_code\")\n  country    String  @default(\"Tunisia\")\n  isDefault  Boolean @default(false) @map(\"is_default\")\n\n  user       User        @relation(fields: [userId], references: [id], onDelete: Cascade)\n  orders     Order[]\n  quotations Quotation[]\n\n  @@map(\"addresses\")\n}\n\n// ============================================\n// CATALOG MANAGEMENT\n// ============================================\n\nmodel Catalog {\n  id          String  @id @default(uuid())\n  name        String // e.g., \"Hardware Catalog\", \"Plumbing Catalog\"\n  slug        String  @unique // URL-friendly: \"hardware\", \"plumbing\"\n  description String? @db.Text\n\n  // Branding (future)\n  logoUrl      String? @map(\"logo_url\")\n  primaryColor String? @map(\"primary_color\")\n\n  // Settings\n  isActive  Boolean @default(true) @map(\"is_active\")\n  isDefault Boolean @default(false) @map(\"is_default\") // Default catalog for new customers\n\n  // TVA Settings (Tunisian Tax System)\n  defaultTvaRate Decimal @default(19) @map(\"default_tva_rate\") @db.Decimal(5, 2) // Default TVA rate for this catalog\n\n  // Metadata\n  createdAt DateTime @default(now()) @map(\"created_at\")\n  updatedAt DateTime @updatedAt @map(\"updated_at\")\n\n  // Relations\n  categories        Category[]\n  products          Product[]\n  catalogCustomers  CatalogCustomer[]\n  bannerSlides      BannerSlide[]\n  catalogProductTva CatalogProductTva[] // Catalog-specific TVA overrides\n\n  @@map(\"catalogs\")\n}\n\nmodel CatalogCustomer {\n  id         String @id @default(uuid())\n  catalogId  String @map(\"catalog_id\")\n  customerId String @map(\"customer_id\")\n\n  // Access control\n  canOrder Boolean @default(true) @map(\"can_order\") // Can place orders\n  canQuote Boolean @default(true) @map(\"can_quote\") // Can request quotations\n\n  // Metadata\n  assignedAt DateTime @default(now()) @map(\"assigned_at\")\n  assignedBy String?  @map(\"assigned_by\") // Admin who assigned\n\n  // Relations\n  catalog  Catalog @relation(fields: [catalogId], references: [id], onDelete: Cascade)\n  customer User    @relation(fields: [customerId], references: [id], onDelete: Cascade)\n  assigner User?   @relation(\"AssignedCatalogs\", fields: [assignedBy], references: [id])\n\n  @@unique([catalogId, customerId])\n  @@map(\"catalog_customers\")\n}\n\n// ============================================\n// PRODUCT CATALOG\n// ============================================\n\nmodel Category {\n  id           String   @id @default(uuid())\n  catalogId    String?  @map(\"catalog_id\") // Link to catalog (nullable for migration)\n  name         String\n  slug         String // Slug unique within catalog\n  description  String?  @db.Text\n  imageUrl     String?  @map(\"image_url\")\n  parentId     String?  @map(\"parent_id\")\n  displayOrder Int      @default(0) @map(\"display_order\")\n  isActive     Boolean  @default(true) @map(\"is_active\")\n  createdAt    DateTime @default(now()) @map(\"created_at\")\n  updatedAt    DateTime @updatedAt @map(\"updated_at\")\n\n  // Relations\n  catalog      Catalog?      @relation(fields: [catalogId], references: [id], onDelete: Cascade)\n  parent       Category?     @relation(\"CategoryHierarchy\", fields: [parentId], references: [id])\n  children     Category[]    @relation(\"CategoryHierarchy\")\n  products     Product[]\n  bannerSlides BannerSlide[]\n\n  @@unique([catalogId, slug]) // Slug unique within catalog\n  @@map(\"categories\")\n}\n\nmodel Product {\n  id               String  @id @default(uuid())\n  catalogId        String? @map(\"catalog_id\") // Link to catalog (nullable for migration)\n  name             String\n  slug             String // Slug unique within catalog\n  description      String? @db.Text\n  shortDescription String? @map(\"short_description\") @db.Text\n  sku              String? // SKU unique within catalog\n  brand            String?\n  basePrice        Decimal @map(\"base_price\") @db.Decimal(10, 2)\n  costPrice        Decimal @default(0.000) @map(\"cost_price\") @db.Decimal(10, 3) // NEW: For margin tracking\n\n  // FODEC Configuration (1% levy on industrial products)\n  fodecSubject Boolean @default(false) @map(\"fodec_subject\")\n\n  // TVA Configuration (Tunisian Tax System)\n  tvaRate         Decimal @default(19) @map(\"tva_rate\") @db.Decimal(5, 2) // 19.00, 7.00, 0.00\n  tvaExempt       Boolean @default(false) @map(\"tva_exempt\") // Product-level exemption\n  tvaExemptReason String? @map(\"tva_exempt_reason\") // e.g., \"Basic food product\", \"Agricultural\"\n\n  // Discount Configuration\n  hasDiscount       Boolean   @default(false) @map(\"has_discount\")\n  discountType      String?   @map(\"discount_type\") // \"percentage\" or \"fixed\"\n  discountValue     Decimal?  @map(\"discount_value\") @db.Decimal(10, 2)\n  discountStartDate DateTime? @map(\"discount_start_date\")\n  discountEndDate   DateTime? @map(\"discount_end_date\")\n\n  categoryId    String   @map(\"category_id\")\n  stockQuantity Int      @default(0) @map(\"stock_quantity\")\n  isActive      Boolean  @default(true) @map(\"is_active\")\n  isFeatured    Boolean  @default(false) @map(\"is_featured\")\n  createdAt     DateTime @default(now()) @map(\"created_at\")\n  updatedAt     DateTime @updatedAt @map(\"updated_at\")\n\n  // Relations\n  catalog             Catalog?               @relation(fields: [catalogId], references: [id], onDelete: Cascade)\n  category            Category               @relation(fields: [categoryId], references: [id])\n  images              ProductImage[]\n  specifications      ProductSpecification[]\n  sizeTable           ProductSizeTable[]\n  packSizes           ProductPackSize[]\n  orderItems          OrderItem[]\n  quotationItems      QuotationItem[]\n  bannerSlides        BannerSlide[]\n  catalogTvaOverrides CatalogProductTva[] // Catalog-specific TVA overrides\n\n  @@unique([catalogId, slug]) // Slug unique within catalog\n  @@unique([catalogId, sku]) // SKU unique within catalog (when not null)\n  @@map(\"products\")\n}\n\nmodel ProductImage {\n  id           String   @id @default(uuid())\n  productId    String   @map(\"product_id\")\n  imageUrl     String   @map(\"image_url\")\n  altText      String?  @map(\"alt_text\")\n  displayOrder Int      @default(0) @map(\"display_order\")\n  isPrimary    Boolean  @default(false) @map(\"is_primary\")\n  createdAt    DateTime @default(now()) @map(\"created_at\")\n\n  product Product @relation(fields: [productId], references: [id], onDelete: Cascade)\n\n  @@map(\"product_images\")\n}\n\nmodel ProductSpecification {\n  id        String   @id @default(uuid())\n  productId String   @map(\"product_id\")\n  specName  String   @map(\"spec_name\")\n  specValue String   @map(\"spec_value\")\n  createdAt DateTime @default(now()) @map(\"created_at\")\n\n  product Product @relation(fields: [productId], references: [id], onDelete: Cascade)\n\n  @@map(\"product_specifications\")\n}\n\nmodel ProductSizeTable {\n  id            String   @id @default(uuid())\n  productId     String   @map(\"product_id\")\n  unitType      String   @map(\"unit_type\") // kg, piece, L, m, etc.\n  size          String\n  price         Decimal  @db.Decimal(10, 2)\n  stockQuantity Int      @map(\"stock_quantity\")\n  createdAt     DateTime @default(now()) @map(\"created_at\")\n  updatedAt     DateTime @updatedAt @map(\"updated_at\")\n\n  product Product @relation(fields: [productId], references: [id], onDelete: Cascade)\n\n  @@unique([productId, size])\n  @@map(\"product_size_tables\")\n}\n\nmodel ProductPackSize {\n  id            String   @id @default(uuid())\n  productId     String   @map(\"product_id\")\n  packType      String   @map(\"pack_type\") // e.g., \"Pack of 12\", \"Pack of 6\", \"Pack of 3\"\n  packQuantity  Int      @map(\"pack_quantity\") // Number of pieces in the pack (12, 6, 3)\n  size          String? // Optional size for this pack (e.g., \"X\", \"Y\", \"Z\")\n  unitType      String?  @map(\"unit_type\") // Optional: m, cm, mm for measurement-based products\n  price         Decimal  @db.Decimal(10, 2)\n  stockQuantity Int      @map(\"stock_quantity\")\n  sku           String? // Optional unique SKU for this pack-size combination\n  createdAt     DateTime @default(now()) @map(\"created_at\")\n  updatedAt     DateTime @updatedAt @map(\"updated_at\")\n\n  product Product @relation(fields: [productId], references: [id], onDelete: Cascade)\n\n  @@unique([productId, packType, size])\n  @@map(\"product_pack_sizes\")\n}\n\n// ============================================\n// CATALOG-SPECIFIC TVA OVERRIDES\n// ============================================\n\nmodel CatalogProductTva {\n  id        String @id @default(uuid())\n  catalogId String @map(\"catalog_id\")\n  productId String @map(\"product_id\")\n\n  // Override TVA settings for this catalog\n  tvaRate   Decimal @map(\"tva_rate\") @db.Decimal(5, 2)\n  tvaExempt Boolean @default(false) @map(\"tva_exempt\")\n  reason    String? @db.Text // Why this catalog has different TVA\n\n  createdAt DateTime @default(now()) @map(\"created_at\")\n  updatedAt DateTime @updatedAt @map(\"updated_at\")\n\n  // Relations\n  catalog Catalog @relation(fields: [catalogId], references: [id], onDelete: Cascade)\n  product Product @relation(fields: [productId], references: [id], onDelete: Cascade)\n\n  @@unique([catalogId, productId])\n  @@map(\"catalog_product_tva\")\n}\n\n// ============================================\n// QUOTATIONS & ORDERS\n// ============================================\n\nenum QuotationStatus {\n  DRAFT // Customer is building the quote\n  PENDING_APPROVAL // Submitted, waiting for admin review\n  APPROVED // Admin approved\n  DECLINED // Admin declined\n  CONVERTED_TO_ORDER // Successfully converted to order\n  EXPIRED // Quote expired (optional feature)\n}\n\nenum OrderStatus {\n  PENDING\n  PROCESSING\n  SHIPPED\n  DELIVERED\n  CANCELLED\n  REFUNDED\n}\n\nenum PaymentMethod {\n  CASH_ON_DELIVERY\n  BANK_TRANSFER\n  CREDIT_CARD\n  NET_TERMS // For B2B orders with payment terms\n  CHEQUE // For B2B cheque payments\n}\n\nenum PaymentStatus {\n  PENDING\n  PAID\n  FAILED\n  REFUNDED\n}\n\nmodel Quotation {\n  id              String          @id @default(uuid())\n  quotationNumber String          @unique @map(\"quotation_number\")\n  userId          String          @map(\"user_id\")\n  status          QuotationStatus @default(DRAFT)\n\n  // TVA Breakdown (Tunisian Tax System)\n  totalBrutHT   Decimal @map(\"total_brut_ht\") @db.Decimal(10, 2) // Sum of (qty × price) before discounts\n  totalDiscount Decimal @default(0) @map(\"total_discount\") @db.Decimal(10, 2) // Sum of all line discounts\n  totalNetHT    Decimal @map(\"total_net_ht\") @db.Decimal(10, 2) // totalBrutHT - totalDiscount\n\n  // TVA breakdown by rate\n  tva19Amount Decimal @default(0) @map(\"tva_19_amount\") @db.Decimal(10, 2)\n  tva7Amount  Decimal @default(0) @map(\"tva_7_amount\") @db.Decimal(10, 2)\n  tva0Amount  Decimal @default(0) @map(\"tva_0_amount\") @db.Decimal(10, 2)\n  totalTVA    Decimal @map(\"total_tva\") @db.Decimal(10, 2) // Sum of all TVA\n\n  netAPayer      Decimal @map(\"net_a_payer\") @db.Decimal(10, 2) // totalNetHT + totalTVA\n  netAPayerWords String? @map(\"net_a_payer_words\") @db.Text // Amount in words (French)\n\n  customerTvaExempt Boolean @default(false) @map(\"customer_tva_exempt\") // Snapshot of customer exemption\n\n  // DEPRECATED (keep for backward compatibility)\n  subtotal               Decimal @db.Decimal(10, 2)\n  taxAmount              Decimal @map(\"tax_amount\") @db.Decimal(10, 2)\n  totalAmount            Decimal @map(\"total_amount\") @db.Decimal(10, 2)\n  anticipatedOutstanding Decimal @map(\"anticipated_outstanding\") @db.Decimal(10, 2)\n\n  // Shipping Info\n  shippingAddressId String? @map(\"shipping_address_id\")\n  shippingAddress   String? @map(\"shipping_address\") @db.Text\n\n  // Admin Decision\n  adminDecisionReason String?   @map(\"admin_decision_reason\") @db.Text\n  reviewedBy          String?   @map(\"reviewed_by\")\n  reviewedAt          DateTime? @map(\"reviewed_at\")\n\n  // Conversion Tracking\n  convertedToOrderId String? @unique @map(\"converted_to_order_id\")\n\n  notes     String?  @db.Text\n  createdAt DateTime @default(now()) @map(\"created_at\")\n  updatedAt DateTime @updatedAt @map(\"updated_at\")\n\n  // Relations\n  user           User            @relation(fields: [userId], references: [id])\n  shippingAddr   Address?        @relation(fields: [shippingAddressId], references: [id])\n  items          QuotationItem[]\n  convertedOrder Order?          @relation(\"ConvertedFromQuotation\", fields: [convertedToOrderId], references: [id])\n  reviewer       User?           @relation(\"ReviewedQuotations\", fields: [reviewedBy], references: [id])\n\n  @@map(\"quotations\")\n}\n\nmodel QuotationItem {\n  id               String  @id @default(uuid())\n  quotationId      String  @map(\"quotation_id\")\n  productId        String  @map(\"product_id\")\n  productName      String  @map(\"product_name\")\n  productSku       String? @map(\"product_sku\")\n  selectedSize     String? @map(\"selected_size\")\n  selectedUnitType String? @map(\"selected_unit_type\")\n  quantity         Int\n  unitPrice        Decimal @map(\"unit_price\") @db.Decimal(10, 2)\n\n  // TVA Calculation Fields (Tunisian Tax System)\n  discount  Decimal @default(0) @map(\"discount\") @db.Decimal(10, 2) // Line discount\n  totalHT   Decimal @map(\"total_ht\") @db.Decimal(10, 2) // Total Hors Taxe (before TVA)\n  tvaRate   Decimal @map(\"tva_rate\") @db.Decimal(5, 2) // TVA rate applied (snapshot)\n  tvaAmount Decimal @map(\"tva_amount\") @db.Decimal(10, 2) // TVA amount\n  totalTTC  Decimal @map(\"total_ttc\") @db.Decimal(10, 2) // Total Toutes Taxes Comprises\n  tvaExempt Boolean @default(false) @map(\"tva_exempt\") // Was this line exempt?\n\n  totalPrice Decimal @map(\"total_price\") @db.Decimal(10, 2) // DEPRECATED: Use totalTTC\n\n  quotation Quotation @relation(fields: [quotationId], references: [id], onDelete: Cascade)\n  product   Product   @relation(fields: [productId], references: [id])\n\n  @@map(\"quotation_items\")\n}\n\nmodel Order {\n  id                String        @id @default(uuid())\n  orderNumber       String        @unique @map(\"order_number\")\n  userId            String?       @map(\"user_id\")\n  customerName      String        @map(\"customer_name\")\n  customerEmail     String        @map(\"customer_email\")\n  customerPhone     String        @map(\"customer_phone\")\n  shippingAddressId String?       @map(\"shipping_address_id\")\n  shippingAddress   String?       @map(\"shipping_address\") @db.Text\n  status            OrderStatus   @default(PENDING)\n  paymentMethod     PaymentMethod @map(\"payment_method\")\n  paymentStatus     PaymentStatus @default(PENDING) @map(\"payment_status\")\n\n  // TVA Breakdown (Tunisian Tax System)\n  totalBrutHT       Decimal @map(\"total_brut_ht\") @db.Decimal(10, 2)\n  totalDiscount     Decimal @default(0) @map(\"total_discount\") @db.Decimal(10, 2)\n  totalNetHT        Decimal @map(\"total_net_ht\") @db.Decimal(10, 2)\n  tva19Amount       Decimal @default(0) @map(\"tva_19_amount\") @db.Decimal(10, 2)\n  tva7Amount        Decimal @default(0) @map(\"tva_7_amount\") @db.Decimal(10, 2)\n  tva0Amount        Decimal @default(0) @map(\"tva_0_amount\") @db.Decimal(10, 2)\n  totalTVA          Decimal @map(\"total_tva\") @db.Decimal(10, 2)\n  netAPayer         Decimal @map(\"net_a_payer\") @db.Decimal(10, 2)\n  netAPayerWords    String? @map(\"net_a_payer_words\") @db.Text\n  customerTvaExempt Boolean @default(false) @map(\"customer_tva_exempt\")\n\n  // DEPRECATED (keep for backward compatibility)\n  subtotal    Decimal @db.Decimal(10, 2)\n  taxAmount   Decimal @map(\"tax_amount\") @db.Decimal(10, 2)\n  totalAmount Decimal @map(\"total_amount\") @db.Decimal(10, 2)\n\n  notes String? @db.Text\n\n  // Fiscal Snapshot Fields (Tunisian Accounting)\n  fiscalTotalHT   Decimal? @default(0) @map(\"fiscal_total_ht\") @db.Decimal(10, 3)\n  fiscalTotalTVA  Decimal? @default(0) @map(\"fiscal_total_tva\") @db.Decimal(10, 3)\n  timbreFiscal    Decimal? @default(1.000) @map(\"timbre_fiscal\") @db.Decimal(10, 3)\n  matriculeFiscal String?  @map(\"matricule_fiscal\") // Snapshot of customer tax ID\n\n  // B2B Enhancements\n  quotationId String?      @unique @map(\"quotation_id\")\n  paymentTerm PaymentTerm? @map(\"payment_term\")\n  dueDate     DateTime?    @map(\"due_date\")\n\n  createdAt DateTime @default(now()) @map(\"created_at\")\n  updatedAt DateTime @updatedAt @map(\"updated_at\")\n\n  // Relations\n  user            User?                @relation(fields: [userId], references: [id])\n  shippingAddr    Address?             @relation(fields: [shippingAddressId], references: [id])\n  items           OrderItem[]\n  statusHistory   OrderStatusHistory[]\n  sourceQuotation Quotation?           @relation(\"ConvertedFromQuotation\")\n\n  @@map(\"orders\")\n}\n\nmodel OrderItem {\n  id               String  @id @default(uuid())\n  orderId          String  @map(\"order_id\")\n  productId        String  @map(\"product_id\")\n  productName      String  @map(\"product_name\")\n  productSku       String? @map(\"product_sku\")\n  selectedSize     String? @map(\"selected_size\")\n  selectedUnitType String? @map(\"selected_unit_type\")\n  quantity         Int\n  unitPrice        Decimal @map(\"unit_price\") @db.Decimal(10, 2)\n\n  // TVA Calculation Fields (Tunisian Tax System)\n  discount  Decimal @default(0) @map(\"discount\") @db.Decimal(10, 2)\n  totalHT   Decimal @map(\"total_ht\") @db.Decimal(10, 2)\n  tvaRate   Decimal @map(\"tva_rate\") @db.Decimal(5, 2)\n  tvaAmount Decimal @map(\"tva_amount\") @db.Decimal(10, 2)\n  totalTTC  Decimal @map(\"total_ttc\") @db.Decimal(10, 2)\n  tvaExempt Boolean @default(false) @map(\"tva_exempt\")\n\n  totalPrice Decimal @map(\"total_price\") @db.Decimal(10, 2) // DEPRECATED\n\n  order   Order   @relation(fields: [orderId], references: [id], onDelete: Cascade)\n  product Product @relation(fields: [productId], references: [id])\n\n  @@map(\"order_items\")\n}\n\nmodel OrderStatusHistory {\n  id        String      @id @default(uuid())\n  orderId   String      @map(\"order_id\")\n  status    OrderStatus\n  notes     String?     @db.Text\n  createdAt DateTime    @default(now()) @map(\"created_at\")\n\n  order Order @relation(fields: [orderId], references: [id], onDelete: Cascade)\n\n  @@map(\"order_status_history\")\n}\n\n// ============================================\n// MARKETING - BANNER SLIDER\n// ============================================\n\nenum SlideType {\n  IMAGE\n  TEXT\n}\n\nmodel BannerSlide {\n  id              String    @id @default(uuid())\n  catalogId       String?   @map(\"catalog_id\") // NEW: Optional catalog assignment\n  title           String?\n  subtitle        String?\n  buttonText      String?   @map(\"button_text\")\n  slideType       SlideType @map(\"slide_type\")\n  imageUrl        String?   @map(\"image_url\")\n  backgroundColor String?   @map(\"background_color\") // For text slides\n  textColor       String?   @map(\"text_color\") // For text slides\n\n  // Link configuration\n  linkType         String? @map(\"link_type\") // \"product\" or \"category\"\n  linkedProductId  String? @map(\"linked_product_id\")\n  linkedCategoryId String? @map(\"linked_category_id\")\n\n  // Display settings\n  displayOrder Int     @default(0) @map(\"display_order\")\n  isActive     Boolean @default(true) @map(\"is_active\")\n  duration     Int?    @default(5) // Duration in seconds, default 5\n\n  createdAt DateTime @default(now()) @map(\"created_at\")\n  updatedAt DateTime @updatedAt @map(\"updated_at\")\n\n  // Relations\n  catalog        Catalog?  @relation(fields: [catalogId], references: [id], onDelete: Cascade)\n  linkedProduct  Product?  @relation(fields: [linkedProductId], references: [id], onDelete: SetNull)\n  linkedCategory Category? @relation(fields: [linkedCategoryId], references: [id], onDelete: SetNull)\n\n  @@map(\"banner_slides\")\n}\n\n// ============================================\n// ANALYTICS (Optional - for future)\n// ============================================\n\nmodel Analytics {\n  id        String   @id @default(uuid())\n  date      DateTime @db.Date\n  metric    String\n  value     Decimal  @db.Decimal(15, 2)\n  metadata  Json?\n  createdAt DateTime @default(now()) @map(\"created_at\")\n\n  @@unique([date, metric])\n  @@map(\"analytics\")\n}\n\n// ============================================\n// SYSTEM SETTINGS\n// ============================================\n\nmodel SystemSetting {\n  key       String   @id\n  value     String   @db.Text // JSON stringified value\n  group     String // 'business', 'notifications', 'system'\n  updatedAt DateTime @updatedAt @map(\"updated_at\")\n\n  @@map(\"system_settings\")\n}\n",
  "inlineSchemaHash": "c5e90919dfc03a362195aa03029babffe9c3de7f692556e03db85e5c23f746d7",
  "copyEngine": true
}
config.dirname = '/'

config.runtimeDataModel = JSON.parse("{\"models\":{\"User\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"email\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"username\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"passwordHash\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"password_hash\"},{\"name\":\"role\",\"kind\":\"enum\",\"type\":\"UserRole\"},{\"name\":\"firstName\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"first_name\"},{\"name\":\"lastName\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"last_name\"},{\"name\":\"phone\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"isActive\",\"kind\":\"scalar\",\"type\":\"Boolean\",\"dbName\":\"is_active\"},{\"name\":\"emailVerified\",\"kind\":\"scalar\",\"type\":\"Boolean\",\"dbName\":\"email_verified\"},{\"name\":\"companyName\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"company_name\"},{\"name\":\"rneNumber\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"rne_number\"},{\"name\":\"rnePdfUrl\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"rne_pdf_url\"},{\"name\":\"taxId\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"tax_id\"},{\"name\":\"customerType\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"customer_type\"},{\"name\":\"financialLimit\",\"kind\":\"scalar\",\"type\":\"Decimal\",\"dbName\":\"financial_limit\"},{\"name\":\"currentOutstanding\",\"kind\":\"scalar\",\"type\":\"Decimal\",\"dbName\":\"current_outstanding\"},{\"name\":\"paymentTerm\",\"kind\":\"enum\",\"type\":\"PaymentTerm\",\"dbName\":\"payment_term\"},{\"name\":\"accountStatus\",\"kind\":\"enum\",\"type\":\"AccountStatus\",\"dbName\":\"account_status\"},{\"name\":\"tvaExempt\",\"kind\":\"scalar\",\"type\":\"Boolean\",\"dbName\":\"tva_exempt\"},{\"name\":\"tvaExemptReason\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"tva_exempt_reason\"},{\"name\":\"annualTurnover\",\"kind\":\"scalar\",\"type\":\"Decimal\",\"dbName\":\"annual_turnover\"},{\"name\":\"tvaExemptValidUntil\",\"kind\":\"scalar\",\"type\":\"DateTime\",\"dbName\":\"tva_exempt_valid_until\"},{\"name\":\"createdAt\",\"kind\":\"scalar\",\"type\":\"DateTime\",\"dbName\":\"created_at\"},{\"name\":\"updatedAt\",\"kind\":\"scalar\",\"type\":\"DateTime\",\"dbName\":\"updated_at\"},{\"name\":\"orders\",\"kind\":\"object\",\"type\":\"Order\",\"relationName\":\"OrderToUser\"},{\"name\":\"addresses\",\"kind\":\"object\",\"type\":\"Address\",\"relationName\":\"AddressToUser\"},{\"name\":\"refreshTokens\",\"kind\":\"object\",\"type\":\"RefreshToken\",\"relationName\":\"RefreshTokenToUser\"},{\"name\":\"quotations\",\"kind\":\"object\",\"type\":\"Quotation\",\"relationName\":\"QuotationToUser\"},{\"name\":\"reviewedQuotations\",\"kind\":\"object\",\"type\":\"Quotation\",\"relationName\":\"ReviewedQuotations\"},{\"name\":\"catalogAssignments\",\"kind\":\"object\",\"type\":\"CatalogCustomer\",\"relationName\":\"CatalogCustomerToUser\"},{\"name\":\"assignedCatalogs\",\"kind\":\"object\",\"type\":\"CatalogCustomer\",\"relationName\":\"AssignedCatalogs\"}],\"dbName\":\"users\"},\"RefreshToken\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"token\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"userId\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"user_id\"},{\"name\":\"expiresAt\",\"kind\":\"scalar\",\"type\":\"DateTime\",\"dbName\":\"expires_at\"},{\"name\":\"createdAt\",\"kind\":\"scalar\",\"type\":\"DateTime\",\"dbName\":\"created_at\"},{\"name\":\"user\",\"kind\":\"object\",\"type\":\"User\",\"relationName\":\"RefreshTokenToUser\"}],\"dbName\":\"refresh_tokens\"},\"Address\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"userId\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"user_id\"},{\"name\":\"label\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"street\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"city\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"state\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"postalCode\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"postal_code\"},{\"name\":\"country\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"isDefault\",\"kind\":\"scalar\",\"type\":\"Boolean\",\"dbName\":\"is_default\"},{\"name\":\"user\",\"kind\":\"object\",\"type\":\"User\",\"relationName\":\"AddressToUser\"},{\"name\":\"orders\",\"kind\":\"object\",\"type\":\"Order\",\"relationName\":\"AddressToOrder\"},{\"name\":\"quotations\",\"kind\":\"object\",\"type\":\"Quotation\",\"relationName\":\"AddressToQuotation\"}],\"dbName\":\"addresses\"},\"Catalog\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"name\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"slug\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"description\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"logoUrl\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"logo_url\"},{\"name\":\"primaryColor\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"primary_color\"},{\"name\":\"isActive\",\"kind\":\"scalar\",\"type\":\"Boolean\",\"dbName\":\"is_active\"},{\"name\":\"isDefault\",\"kind\":\"scalar\",\"type\":\"Boolean\",\"dbName\":\"is_default\"},{\"name\":\"defaultTvaRate\",\"kind\":\"scalar\",\"type\":\"Decimal\",\"dbName\":\"default_tva_rate\"},{\"name\":\"createdAt\",\"kind\":\"scalar\",\"type\":\"DateTime\",\"dbName\":\"created_at\"},{\"name\":\"updatedAt\",\"kind\":\"scalar\",\"type\":\"DateTime\",\"dbName\":\"updated_at\"},{\"name\":\"categories\",\"kind\":\"object\",\"type\":\"Category\",\"relationName\":\"CatalogToCategory\"},{\"name\":\"products\",\"kind\":\"object\",\"type\":\"Product\",\"relationName\":\"CatalogToProduct\"},{\"name\":\"catalogCustomers\",\"kind\":\"object\",\"type\":\"CatalogCustomer\",\"relationName\":\"CatalogToCatalogCustomer\"},{\"name\":\"bannerSlides\",\"kind\":\"object\",\"type\":\"BannerSlide\",\"relationName\":\"BannerSlideToCatalog\"},{\"name\":\"catalogProductTva\",\"kind\":\"object\",\"type\":\"CatalogProductTva\",\"relationName\":\"CatalogToCatalogProductTva\"}],\"dbName\":\"catalogs\"},\"CatalogCustomer\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"catalogId\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"catalog_id\"},{\"name\":\"customerId\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"customer_id\"},{\"name\":\"canOrder\",\"kind\":\"scalar\",\"type\":\"Boolean\",\"dbName\":\"can_order\"},{\"name\":\"canQuote\",\"kind\":\"scalar\",\"type\":\"Boolean\",\"dbName\":\"can_quote\"},{\"name\":\"assignedAt\",\"kind\":\"scalar\",\"type\":\"DateTime\",\"dbName\":\"assigned_at\"},{\"name\":\"assignedBy\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"assigned_by\"},{\"name\":\"catalog\",\"kind\":\"object\",\"type\":\"Catalog\",\"relationName\":\"CatalogToCatalogCustomer\"},{\"name\":\"customer\",\"kind\":\"object\",\"type\":\"User\",\"relationName\":\"CatalogCustomerToUser\"},{\"name\":\"assigner\",\"kind\":\"object\",\"type\":\"User\",\"relationName\":\"AssignedCatalogs\"}],\"dbName\":\"catalog_customers\"},\"Category\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"catalogId\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"catalog_id\"},{\"name\":\"name\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"slug\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"description\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"imageUrl\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"image_url\"},{\"name\":\"parentId\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"parent_id\"},{\"name\":\"displayOrder\",\"kind\":\"scalar\",\"type\":\"Int\",\"dbName\":\"display_order\"},{\"name\":\"isActive\",\"kind\":\"scalar\",\"type\":\"Boolean\",\"dbName\":\"is_active\"},{\"name\":\"createdAt\",\"kind\":\"scalar\",\"type\":\"DateTime\",\"dbName\":\"created_at\"},{\"name\":\"updatedAt\",\"kind\":\"scalar\",\"type\":\"DateTime\",\"dbName\":\"updated_at\"},{\"name\":\"catalog\",\"kind\":\"object\",\"type\":\"Catalog\",\"relationName\":\"CatalogToCategory\"},{\"name\":\"parent\",\"kind\":\"object\",\"type\":\"Category\",\"relationName\":\"CategoryHierarchy\"},{\"name\":\"children\",\"kind\":\"object\",\"type\":\"Category\",\"relationName\":\"CategoryHierarchy\"},{\"name\":\"products\",\"kind\":\"object\",\"type\":\"Product\",\"relationName\":\"CategoryToProduct\"},{\"name\":\"bannerSlides\",\"kind\":\"object\",\"type\":\"BannerSlide\",\"relationName\":\"BannerSlideToCategory\"}],\"dbName\":\"categories\"},\"Product\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"catalogId\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"catalog_id\"},{\"name\":\"name\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"slug\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"description\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"shortDescription\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"short_description\"},{\"name\":\"sku\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"brand\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"basePrice\",\"kind\":\"scalar\",\"type\":\"Decimal\",\"dbName\":\"base_price\"},{\"name\":\"costPrice\",\"kind\":\"scalar\",\"type\":\"Decimal\",\"dbName\":\"cost_price\"},{\"name\":\"fodecSubject\",\"kind\":\"scalar\",\"type\":\"Boolean\",\"dbName\":\"fodec_subject\"},{\"name\":\"tvaRate\",\"kind\":\"scalar\",\"type\":\"Decimal\",\"dbName\":\"tva_rate\"},{\"name\":\"tvaExempt\",\"kind\":\"scalar\",\"type\":\"Boolean\",\"dbName\":\"tva_exempt\"},{\"name\":\"tvaExemptReason\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"tva_exempt_reason\"},{\"name\":\"hasDiscount\",\"kind\":\"scalar\",\"type\":\"Boolean\",\"dbName\":\"has_discount\"},{\"name\":\"discountType\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"discount_type\"},{\"name\":\"discountValue\",\"kind\":\"scalar\",\"type\":\"Decimal\",\"dbName\":\"discount_value\"},{\"name\":\"discountStartDate\",\"kind\":\"scalar\",\"type\":\"DateTime\",\"dbName\":\"discount_start_date\"},{\"name\":\"discountEndDate\",\"kind\":\"scalar\",\"type\":\"DateTime\",\"dbName\":\"discount_end_date\"},{\"name\":\"categoryId\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"category_id\"},{\"name\":\"stockQuantity\",\"kind\":\"scalar\",\"type\":\"Int\",\"dbName\":\"stock_quantity\"},{\"name\":\"isActive\",\"kind\":\"scalar\",\"type\":\"Boolean\",\"dbName\":\"is_active\"},{\"name\":\"isFeatured\",\"kind\":\"scalar\",\"type\":\"Boolean\",\"dbName\":\"is_featured\"},{\"name\":\"createdAt\",\"kind\":\"scalar\",\"type\":\"DateTime\",\"dbName\":\"created_at\"},{\"name\":\"updatedAt\",\"kind\":\"scalar\",\"type\":\"DateTime\",\"dbName\":\"updated_at\"},{\"name\":\"catalog\",\"kind\":\"object\",\"type\":\"Catalog\",\"relationName\":\"CatalogToProduct\"},{\"name\":\"category\",\"kind\":\"object\",\"type\":\"Category\",\"relationName\":\"CategoryToProduct\"},{\"name\":\"images\",\"kind\":\"object\",\"type\":\"ProductImage\",\"relationName\":\"ProductToProductImage\"},{\"name\":\"specifications\",\"kind\":\"object\",\"type\":\"ProductSpecification\",\"relationName\":\"ProductToProductSpecification\"},{\"name\":\"sizeTable\",\"kind\":\"object\",\"type\":\"ProductSizeTable\",\"relationName\":\"ProductToProductSizeTable\"},{\"name\":\"packSizes\",\"kind\":\"object\",\"type\":\"ProductPackSize\",\"relationName\":\"ProductToProductPackSize\"},{\"name\":\"orderItems\",\"kind\":\"object\",\"type\":\"OrderItem\",\"relationName\":\"OrderItemToProduct\"},{\"name\":\"quotationItems\",\"kind\":\"object\",\"type\":\"QuotationItem\",\"relationName\":\"ProductToQuotationItem\"},{\"name\":\"bannerSlides\",\"kind\":\"object\",\"type\":\"BannerSlide\",\"relationName\":\"BannerSlideToProduct\"},{\"name\":\"catalogTvaOverrides\",\"kind\":\"object\",\"type\":\"CatalogProductTva\",\"relationName\":\"CatalogProductTvaToProduct\"}],\"dbName\":\"products\"},\"ProductImage\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"productId\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"product_id\"},{\"name\":\"imageUrl\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"image_url\"},{\"name\":\"altText\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"alt_text\"},{\"name\":\"displayOrder\",\"kind\":\"scalar\",\"type\":\"Int\",\"dbName\":\"display_order\"},{\"name\":\"isPrimary\",\"kind\":\"scalar\",\"type\":\"Boolean\",\"dbName\":\"is_primary\"},{\"name\":\"createdAt\",\"kind\":\"scalar\",\"type\":\"DateTime\",\"dbName\":\"created_at\"},{\"name\":\"product\",\"kind\":\"object\",\"type\":\"Product\",\"relationName\":\"ProductToProductImage\"}],\"dbName\":\"product_images\"},\"ProductSpecification\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"productId\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"product_id\"},{\"name\":\"specName\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"spec_name\"},{\"name\":\"specValue\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"spec_value\"},{\"name\":\"createdAt\",\"kind\":\"scalar\",\"type\":\"DateTime\",\"dbName\":\"created_at\"},{\"name\":\"product\",\"kind\":\"object\",\"type\":\"Product\",\"relationName\":\"ProductToProductSpecification\"}],\"dbName\":\"product_specifications\"},\"ProductSizeTable\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"productId\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"product_id\"},{\"name\":\"unitType\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"unit_type\"},{\"name\":\"size\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"price\",\"kind\":\"scalar\",\"type\":\"Decimal\"},{\"name\":\"stockQuantity\",\"kind\":\"scalar\",\"type\":\"Int\",\"dbName\":\"stock_quantity\"},{\"name\":\"createdAt\",\"kind\":\"scalar\",\"type\":\"DateTime\",\"dbName\":\"created_at\"},{\"name\":\"updatedAt\",\"kind\":\"scalar\",\"type\":\"DateTime\",\"dbName\":\"updated_at\"},{\"name\":\"product\",\"kind\":\"object\",\"type\":\"Product\",\"relationName\":\"ProductToProductSizeTable\"}],\"dbName\":\"product_size_tables\"},\"ProductPackSize\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"productId\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"product_id\"},{\"name\":\"packType\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"pack_type\"},{\"name\":\"packQuantity\",\"kind\":\"scalar\",\"type\":\"Int\",\"dbName\":\"pack_quantity\"},{\"name\":\"size\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"unitType\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"unit_type\"},{\"name\":\"price\",\"kind\":\"scalar\",\"type\":\"Decimal\"},{\"name\":\"stockQuantity\",\"kind\":\"scalar\",\"type\":\"Int\",\"dbName\":\"stock_quantity\"},{\"name\":\"sku\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"createdAt\",\"kind\":\"scalar\",\"type\":\"DateTime\",\"dbName\":\"created_at\"},{\"name\":\"updatedAt\",\"kind\":\"scalar\",\"type\":\"DateTime\",\"dbName\":\"updated_at\"},{\"name\":\"product\",\"kind\":\"object\",\"type\":\"Product\",\"relationName\":\"ProductToProductPackSize\"}],\"dbName\":\"product_pack_sizes\"},\"CatalogProductTva\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"catalogId\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"catalog_id\"},{\"name\":\"productId\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"product_id\"},{\"name\":\"tvaRate\",\"kind\":\"scalar\",\"type\":\"Decimal\",\"dbName\":\"tva_rate\"},{\"name\":\"tvaExempt\",\"kind\":\"scalar\",\"type\":\"Boolean\",\"dbName\":\"tva_exempt\"},{\"name\":\"reason\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"createdAt\",\"kind\":\"scalar\",\"type\":\"DateTime\",\"dbName\":\"created_at\"},{\"name\":\"updatedAt\",\"kind\":\"scalar\",\"type\":\"DateTime\",\"dbName\":\"updated_at\"},{\"name\":\"catalog\",\"kind\":\"object\",\"type\":\"Catalog\",\"relationName\":\"CatalogToCatalogProductTva\"},{\"name\":\"product\",\"kind\":\"object\",\"type\":\"Product\",\"relationName\":\"CatalogProductTvaToProduct\"}],\"dbName\":\"catalog_product_tva\"},\"Quotation\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"quotationNumber\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"quotation_number\"},{\"name\":\"userId\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"user_id\"},{\"name\":\"status\",\"kind\":\"enum\",\"type\":\"QuotationStatus\"},{\"name\":\"totalBrutHT\",\"kind\":\"scalar\",\"type\":\"Decimal\",\"dbName\":\"total_brut_ht\"},{\"name\":\"totalDiscount\",\"kind\":\"scalar\",\"type\":\"Decimal\",\"dbName\":\"total_discount\"},{\"name\":\"totalNetHT\",\"kind\":\"scalar\",\"type\":\"Decimal\",\"dbName\":\"total_net_ht\"},{\"name\":\"tva19Amount\",\"kind\":\"scalar\",\"type\":\"Decimal\",\"dbName\":\"tva_19_amount\"},{\"name\":\"tva7Amount\",\"kind\":\"scalar\",\"type\":\"Decimal\",\"dbName\":\"tva_7_amount\"},{\"name\":\"tva0Amount\",\"kind\":\"scalar\",\"type\":\"Decimal\",\"dbName\":\"tva_0_amount\"},{\"name\":\"totalTVA\",\"kind\":\"scalar\",\"type\":\"Decimal\",\"dbName\":\"total_tva\"},{\"name\":\"netAPayer\",\"kind\":\"scalar\",\"type\":\"Decimal\",\"dbName\":\"net_a_payer\"},{\"name\":\"netAPayerWords\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"net_a_payer_words\"},{\"name\":\"customerTvaExempt\",\"kind\":\"scalar\",\"type\":\"Boolean\",\"dbName\":\"customer_tva_exempt\"},{\"name\":\"subtotal\",\"kind\":\"scalar\",\"type\":\"Decimal\"},{\"name\":\"taxAmount\",\"kind\":\"scalar\",\"type\":\"Decimal\",\"dbName\":\"tax_amount\"},{\"name\":\"totalAmount\",\"kind\":\"scalar\",\"type\":\"Decimal\",\"dbName\":\"total_amount\"},{\"name\":\"anticipatedOutstanding\",\"kind\":\"scalar\",\"type\":\"Decimal\",\"dbName\":\"anticipated_outstanding\"},{\"name\":\"shippingAddressId\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"shipping_address_id\"},{\"name\":\"shippingAddress\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"shipping_address\"},{\"name\":\"adminDecisionReason\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"admin_decision_reason\"},{\"name\":\"reviewedBy\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"reviewed_by\"},{\"name\":\"reviewedAt\",\"kind\":\"scalar\",\"type\":\"DateTime\",\"dbName\":\"reviewed_at\"},{\"name\":\"convertedToOrderId\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"converted_to_order_id\"},{\"name\":\"notes\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"createdAt\",\"kind\":\"scalar\",\"type\":\"DateTime\",\"dbName\":\"created_at\"},{\"name\":\"updatedAt\",\"kind\":\"scalar\",\"type\":\"DateTime\",\"dbName\":\"updated_at\"},{\"name\":\"user\",\"kind\":\"object\",\"type\":\"User\",\"relationName\":\"QuotationToUser\"},{\"name\":\"shippingAddr\",\"kind\":\"object\",\"type\":\"Address\",\"relationName\":\"AddressToQuotation\"},{\"name\":\"items\",\"kind\":\"object\",\"type\":\"QuotationItem\",\"relationName\":\"QuotationToQuotationItem\"},{\"name\":\"convertedOrder\",\"kind\":\"object\",\"type\":\"Order\",\"relationName\":\"ConvertedFromQuotation\"},{\"name\":\"reviewer\",\"kind\":\"object\",\"type\":\"User\",\"relationName\":\"ReviewedQuotations\"}],\"dbName\":\"quotations\"},\"QuotationItem\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"quotationId\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"quotation_id\"},{\"name\":\"productId\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"product_id\"},{\"name\":\"productName\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"product_name\"},{\"name\":\"productSku\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"product_sku\"},{\"name\":\"selectedSize\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"selected_size\"},{\"name\":\"selectedUnitType\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"selected_unit_type\"},{\"name\":\"quantity\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"unitPrice\",\"kind\":\"scalar\",\"type\":\"Decimal\",\"dbName\":\"unit_price\"},{\"name\":\"discount\",\"kind\":\"scalar\",\"type\":\"Decimal\",\"dbName\":\"discount\"},{\"name\":\"totalHT\",\"kind\":\"scalar\",\"type\":\"Decimal\",\"dbName\":\"total_ht\"},{\"name\":\"tvaRate\",\"kind\":\"scalar\",\"type\":\"Decimal\",\"dbName\":\"tva_rate\"},{\"name\":\"tvaAmount\",\"kind\":\"scalar\",\"type\":\"Decimal\",\"dbName\":\"tva_amount\"},{\"name\":\"totalTTC\",\"kind\":\"scalar\",\"type\":\"Decimal\",\"dbName\":\"total_ttc\"},{\"name\":\"tvaExempt\",\"kind\":\"scalar\",\"type\":\"Boolean\",\"dbName\":\"tva_exempt\"},{\"name\":\"totalPrice\",\"kind\":\"scalar\",\"type\":\"Decimal\",\"dbName\":\"total_price\"},{\"name\":\"quotation\",\"kind\":\"object\",\"type\":\"Quotation\",\"relationName\":\"QuotationToQuotationItem\"},{\"name\":\"product\",\"kind\":\"object\",\"type\":\"Product\",\"relationName\":\"ProductToQuotationItem\"}],\"dbName\":\"quotation_items\"},\"Order\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"orderNumber\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"order_number\"},{\"name\":\"userId\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"user_id\"},{\"name\":\"customerName\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"customer_name\"},{\"name\":\"customerEmail\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"customer_email\"},{\"name\":\"customerPhone\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"customer_phone\"},{\"name\":\"shippingAddressId\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"shipping_address_id\"},{\"name\":\"shippingAddress\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"shipping_address\"},{\"name\":\"status\",\"kind\":\"enum\",\"type\":\"OrderStatus\"},{\"name\":\"paymentMethod\",\"kind\":\"enum\",\"type\":\"PaymentMethod\",\"dbName\":\"payment_method\"},{\"name\":\"paymentStatus\",\"kind\":\"enum\",\"type\":\"PaymentStatus\",\"dbName\":\"payment_status\"},{\"name\":\"totalBrutHT\",\"kind\":\"scalar\",\"type\":\"Decimal\",\"dbName\":\"total_brut_ht\"},{\"name\":\"totalDiscount\",\"kind\":\"scalar\",\"type\":\"Decimal\",\"dbName\":\"total_discount\"},{\"name\":\"totalNetHT\",\"kind\":\"scalar\",\"type\":\"Decimal\",\"dbName\":\"total_net_ht\"},{\"name\":\"tva19Amount\",\"kind\":\"scalar\",\"type\":\"Decimal\",\"dbName\":\"tva_19_amount\"},{\"name\":\"tva7Amount\",\"kind\":\"scalar\",\"type\":\"Decimal\",\"dbName\":\"tva_7_amount\"},{\"name\":\"tva0Amount\",\"kind\":\"scalar\",\"type\":\"Decimal\",\"dbName\":\"tva_0_amount\"},{\"name\":\"totalTVA\",\"kind\":\"scalar\",\"type\":\"Decimal\",\"dbName\":\"total_tva\"},{\"name\":\"netAPayer\",\"kind\":\"scalar\",\"type\":\"Decimal\",\"dbName\":\"net_a_payer\"},{\"name\":\"netAPayerWords\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"net_a_payer_words\"},{\"name\":\"customerTvaExempt\",\"kind\":\"scalar\",\"type\":\"Boolean\",\"dbName\":\"customer_tva_exempt\"},{\"name\":\"subtotal\",\"kind\":\"scalar\",\"type\":\"Decimal\"},{\"name\":\"taxAmount\",\"kind\":\"scalar\",\"type\":\"Decimal\",\"dbName\":\"tax_amount\"},{\"name\":\"totalAmount\",\"kind\":\"scalar\",\"type\":\"Decimal\",\"dbName\":\"total_amount\"},{\"name\":\"notes\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"fiscalTotalHT\",\"kind\":\"scalar\",\"type\":\"Decimal\",\"dbName\":\"fiscal_total_ht\"},{\"name\":\"fiscalTotalTVA\",\"kind\":\"scalar\",\"type\":\"Decimal\",\"dbName\":\"fiscal_total_tva\"},{\"name\":\"timbreFiscal\",\"kind\":\"scalar\",\"type\":\"Decimal\",\"dbName\":\"timbre_fiscal\"},{\"name\":\"matriculeFiscal\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"matricule_fiscal\"},{\"name\":\"quotationId\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"quotation_id\"},{\"name\":\"paymentTerm\",\"kind\":\"enum\",\"type\":\"PaymentTerm\",\"dbName\":\"payment_term\"},{\"name\":\"dueDate\",\"kind\":\"scalar\",\"type\":\"DateTime\",\"dbName\":\"due_date\"},{\"name\":\"createdAt\",\"kind\":\"scalar\",\"type\":\"DateTime\",\"dbName\":\"created_at\"},{\"name\":\"updatedAt\",\"kind\":\"scalar\",\"type\":\"DateTime\",\"dbName\":\"updated_at\"},{\"name\":\"user\",\"kind\":\"object\",\"type\":\"User\",\"relationName\":\"OrderToUser\"},{\"name\":\"shippingAddr\",\"kind\":\"object\",\"type\":\"Address\",\"relationName\":\"AddressToOrder\"},{\"name\":\"items\",\"kind\":\"object\",\"type\":\"OrderItem\",\"relationName\":\"OrderToOrderItem\"},{\"name\":\"statusHistory\",\"kind\":\"object\",\"type\":\"OrderStatusHistory\",\"relationName\":\"OrderToOrderStatusHistory\"},{\"name\":\"sourceQuotation\",\"kind\":\"object\",\"type\":\"Quotation\",\"relationName\":\"ConvertedFromQuotation\"}],\"dbName\":\"orders\"},\"OrderItem\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"orderId\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"order_id\"},{\"name\":\"productId\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"product_id\"},{\"name\":\"productName\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"product_name\"},{\"name\":\"productSku\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"product_sku\"},{\"name\":\"selectedSize\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"selected_size\"},{\"name\":\"selectedUnitType\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"selected_unit_type\"},{\"name\":\"quantity\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"unitPrice\",\"kind\":\"scalar\",\"type\":\"Decimal\",\"dbName\":\"unit_price\"},{\"name\":\"discount\",\"kind\":\"scalar\",\"type\":\"Decimal\",\"dbName\":\"discount\"},{\"name\":\"totalHT\",\"kind\":\"scalar\",\"type\":\"Decimal\",\"dbName\":\"total_ht\"},{\"name\":\"tvaRate\",\"kind\":\"scalar\",\"type\":\"Decimal\",\"dbName\":\"tva_rate\"},{\"name\":\"tvaAmount\",\"kind\":\"scalar\",\"type\":\"Decimal\",\"dbName\":\"tva_amount\"},{\"name\":\"totalTTC\",\"kind\":\"scalar\",\"type\":\"Decimal\",\"dbName\":\"total_ttc\"},{\"name\":\"tvaExempt\",\"kind\":\"scalar\",\"type\":\"Boolean\",\"dbName\":\"tva_exempt\"},{\"name\":\"totalPrice\",\"kind\":\"scalar\",\"type\":\"Decimal\",\"dbName\":\"total_price\"},{\"name\":\"order\",\"kind\":\"object\",\"type\":\"Order\",\"relationName\":\"OrderToOrderItem\"},{\"name\":\"product\",\"kind\":\"object\",\"type\":\"Product\",\"relationName\":\"OrderItemToProduct\"}],\"dbName\":\"order_items\"},\"OrderStatusHistory\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"orderId\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"order_id\"},{\"name\":\"status\",\"kind\":\"enum\",\"type\":\"OrderStatus\"},{\"name\":\"notes\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"createdAt\",\"kind\":\"scalar\",\"type\":\"DateTime\",\"dbName\":\"created_at\"},{\"name\":\"order\",\"kind\":\"object\",\"type\":\"Order\",\"relationName\":\"OrderToOrderStatusHistory\"}],\"dbName\":\"order_status_history\"},\"BannerSlide\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"catalogId\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"catalog_id\"},{\"name\":\"title\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"subtitle\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"buttonText\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"button_text\"},{\"name\":\"slideType\",\"kind\":\"enum\",\"type\":\"SlideType\",\"dbName\":\"slide_type\"},{\"name\":\"imageUrl\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"image_url\"},{\"name\":\"backgroundColor\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"background_color\"},{\"name\":\"textColor\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"text_color\"},{\"name\":\"linkType\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"link_type\"},{\"name\":\"linkedProductId\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"linked_product_id\"},{\"name\":\"linkedCategoryId\",\"kind\":\"scalar\",\"type\":\"String\",\"dbName\":\"linked_category_id\"},{\"name\":\"displayOrder\",\"kind\":\"scalar\",\"type\":\"Int\",\"dbName\":\"display_order\"},{\"name\":\"isActive\",\"kind\":\"scalar\",\"type\":\"Boolean\",\"dbName\":\"is_active\"},{\"name\":\"duration\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"createdAt\",\"kind\":\"scalar\",\"type\":\"DateTime\",\"dbName\":\"created_at\"},{\"name\":\"updatedAt\",\"kind\":\"scalar\",\"type\":\"DateTime\",\"dbName\":\"updated_at\"},{\"name\":\"catalog\",\"kind\":\"object\",\"type\":\"Catalog\",\"relationName\":\"BannerSlideToCatalog\"},{\"name\":\"linkedProduct\",\"kind\":\"object\",\"type\":\"Product\",\"relationName\":\"BannerSlideToProduct\"},{\"name\":\"linkedCategory\",\"kind\":\"object\",\"type\":\"Category\",\"relationName\":\"BannerSlideToCategory\"}],\"dbName\":\"banner_slides\"},\"Analytics\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"date\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"metric\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"value\",\"kind\":\"scalar\",\"type\":\"Decimal\"},{\"name\":\"metadata\",\"kind\":\"scalar\",\"type\":\"Json\"},{\"name\":\"createdAt\",\"kind\":\"scalar\",\"type\":\"DateTime\",\"dbName\":\"created_at\"}],\"dbName\":\"analytics\"},\"SystemSetting\":{\"fields\":[{\"name\":\"key\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"value\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"group\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"updatedAt\",\"kind\":\"scalar\",\"type\":\"DateTime\",\"dbName\":\"updated_at\"}],\"dbName\":\"system_settings\"}},\"enums\":{},\"types\":{}}")
defineDmmfProperty(exports.Prisma, config.runtimeDataModel)
config.engineWasm = {
  getRuntime: async () => require('./query_engine_bg.js'),
  getQueryEngineWasmModule: async () => {
    const loader = (await import('#wasm-engine-loader')).default
    const engine = (await loader).default
    return engine
  }
}
config.compilerWasm = undefined

config.injectableEdgeEnv = () => ({
  parsed: {
    DATABASE_URL: typeof globalThis !== 'undefined' && globalThis['DATABASE_URL'] || typeof process !== 'undefined' && process.env && process.env.DATABASE_URL || undefined
  }
})

if (typeof globalThis !== 'undefined' && globalThis['DEBUG'] || typeof process !== 'undefined' && process.env && process.env.DEBUG || undefined) {
  Debug.enable(typeof globalThis !== 'undefined' && globalThis['DEBUG'] || typeof process !== 'undefined' && process.env && process.env.DEBUG || undefined)
}

const PrismaClient = getPrismaClient(config)
exports.PrismaClient = PrismaClient
Object.assign(exports, Prisma)

