

const API_URL = 'http://localhost:3001/api';

async function testRBAC() {
    console.log('Starting RBAC Verification...');

    // 1. Simulate Login as Super Admin (we need a way to get a token, or we can mock it if we had a seed user)
    // Since I can't easily login via UI, I will assume there is a seed admin or create one via prisma if direct access was possible,
    // but I can try to register one if allowed or use existing 'admin@smd-tunisie.com' / 'admin123' (from LoginPage demo credentials)

    let superAdminToken = '';
    let salesAdminToken = '';

    // Login Super Admin
    try {
        const res = await fetch(`${API_URL}/auth/login`, {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({ email: 'admin@smd-tunisie.com', password: 'admin123' }) // Assuming this user exists and is ADMIN (treated as SUPER)
        });

        if (res.ok) {
            const data = await res.json() as any;
            superAdminToken = data.data.token;
            console.log('✅ Super Admin Login Success');
        } else {
            console.error('❌ Super Admin Login Failed');
            return;
        }
    } catch (e) {
        console.error('API not reachable', e);
        return;
    }

    // 2. Create a Sales Admin using Super Admin token
    try {
        const email = `sales-${Date.now()}@test.com`;
        const res = await fetch(`${API_URL}/admin/users`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'Authorization': `Bearer ${superAdminToken}`
            },
            body: JSON.stringify({
                email,
                password: 'password123',
                firstName: 'Sales',
                lastName: 'Admin',
                role: 'SALES_ADMIN',
                phone: '12345678'
            })
        });

        if (res.ok) {
            console.log('✅ Create Sales Admin Success');
            // Login as Sales Admin
            const loginRes = await fetch(`${API_URL}/auth/login`, {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify({ email, password: 'password123' })
            });
            const data = await loginRes.json() as any;
            salesAdminToken = data.data.token;
            console.log('✅ Sales Admin Login Success');
        } else {
            console.error('❌ Create Sales Admin Failed', await res.text());
        }
    } catch (e) {
        console.error(e);
    }

    // 3. Verify Sales Admin Access
    // CAN view orders
    const ordersRes = await fetch(`${API_URL}/orders`, {
        headers: { 'Authorization': `Bearer ${salesAdminToken}` }
    });
    if (ordersRes.ok) console.log('✅ Sales Admin CAN view orders');
    else console.error('❌ Sales Admin SHOULD view orders but failed');

    // CANNOT view accounting stats (needs ACCOUNTING_VIEW, Sales has ACCOUNTING_VIEW? let's check auth.ts: ACCOUNTING_VIEW: ['SUPER_ADMIN', 'ADMIN', 'ACCOUNTING_ADMIN', 'SALES_ADMIN']. Wait, Sales CAN view invoices. But /api/admin/accounting/stats? 
    // auth.ts says: router.use(authorize(...PERMISSIONS.ACCOUNTING_VIEW)); for accounting routes.
    // And PERMISSIONS.ACCOUNTING_VIEW includes SALES_ADMIN.
    // So Sales Admin CAN view accounting stats. My Implementation Plan might have been stricter.
    // Let's check settings: PERMISSIONS.SETTINGS_MANAGE = ['SUPER_ADMIN', 'ADMIN']. Sales should NOT access.

    // CANNOT view settings
    const settingsRes = await fetch(`${API_URL}/settings`, {
        headers: { 'Authorization': `Bearer ${salesAdminToken}` }
    });
    if (settingsRes.status === 403) console.log('✅ Sales Admin CANNOT view settings (Correct)');
    else console.error(`❌ Sales Admin SHOULD NOT view settings, got ${settingsRes.status}`);

    // 4. Create Accounting Admin
    // ... (similar steps)
}

testRBAC();
